#ifndef _IHANDLER_
#define _IHANDLER_
/*******************************************************************************
* FILE NAME: ihandler.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IHandler                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ievent.hpp>

class IString;
class IWindow;

#pragma pack(4)

class IHandler : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHandler ( );
virtual
 ~IHandler ( );

/*--------------------- Enabling and Disabling Handlers ----------------------*/
virtual IHandler
 &enable    ( Boolean enable = true ),
 &disable   ( );

Boolean
  isEnabled ( ) const;

/*---------------------------- Event Dispatching -----------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

/*------------------------------- Diagnostics --------------------------------*/
virtual IString
  asString    ( ) const,
  asDebugInfo ( ) const;

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event ) = 0;

/*----------------------------- Event Processing -----------------------------*/
virtual IEventResult
  defaultProcedure ( IEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
friend IWindow;
Boolean
  active;
unsigned
  numWindows;
}; // IHandler

#pragma pack()

  #include <ihandler.inl>

#endif /* _IHANDLER_ */
