#ifndef _IHELPEVT_
#define _IHELPEVT_
/*******************************************************************************
* FILE NAME: ihelpevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the class(es):                    *
*     IHelpMenuBarEvent                                                        *
*     IHelpErrorEvent                                                          *
*     IHelpHypertextEvent (obsolete and replaced by IHelpHyperlinkEvent)       *
*     IHelpHyperlinkEvent                                                      *
*     IHelpSubitemNotFoundEvent                                                *
*     IHelpTutorialEvent                                                       *
*     IHelpNotifyEvent                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

#pragma pack(4)

class IHelpMenuBarEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpMenuBarEvent ( const IEvent& event );
virtual
 ~IHelpMenuBarEvent ( );

/*----------------------------- Menu Information -----------------------------*/
unsigned long
  commandId ( ) const;
}; // IHelpMenuBarEvent


class IHelpErrorEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpErrorEvent ( const IEvent& event );
virtual
 ~IHelpErrorEvent ( );

/*-------------------------------- Error Type --------------------------------*/
enum ErrorType {
  loadingDLL,
  noWindow,
  invalidAppHandle,
  invalidInstanceHandle,
  noHelpInstance,
  invalidQueryHandle,
  noHelpTable,
  invalidId,
  noIndex,
  noContent,
  openHelpFile,
  readHelpFile,
  closeHelpFile,
  invalidHelpFile,
  notEnoughMemory,
  unableFreeMemory,
  invalidHelpWindow,
  unopenDatabase,
  fontNotFound,
  unknown
}; // ErrorType

ErrorType
  error ( ) const;
}; // IHelpErrorEvent


class IHelpHyperlinkEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpHyperlinkEvent ( const IEvent& event );
virtual
 ~IHelpHyperlinkEvent ( );

/*----------------------------- Link Information -----------------------------*/
unsigned long
  id ( ) const;
}; // IHelpHyperlinkEvent


class IHelpSubitemNotFoundEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpSubitemNotFoundEvent ( const IEvent& event );
virtual
 ~IHelpSubitemNotFoundEvent ( );

/*-------------------------------- Help Item ---------------------------------*/
Boolean
  isWindow   ( ) const,
  isFrame    ( ) const,
  isMenu     ( ) const;

unsigned long
  topicId    ( ) const,
  subtopicId ( ) const;
}; // IHelpSubitemNotFoundEvent


class IHelpTutorialEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpTutorialEvent ( const IEvent& event );
virtual
 ~IHelpTutorialEvent ( );

/*--------------------------------- Tutorial ---------------------------------*/
IString
  tutorialName        ( )  const;
}; // IHelpTutorialEvent


class IHelpNotifyEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpNotifyEvent ( const IEvent& event );
virtual
 ~IHelpNotifyEvent ( );

/*------------------------------- Help Window --------------------------------*/
IWindowHandle
  windowHandle ( ) const;

/*----------------------------- Selected Control -----------------------------*/
unsigned long
  controlId ( ) const;
}; // IHelpNotifyEvent

#pragma pack()

#endif // _IHELPEVT_
