#ifndef _IHELPHDR_
#define _IHELPHDR_
/*******************************************************************************
* FILE NAME: ihelphdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IHelpHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ihelpevt.hpp>

class IFrameWindow;

#pragma pack(4)

class IHelpHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpHandler ( );
virtual
 ~IHelpHandler ( );

/*---------------------------- Event Dispatching -----------------------------*/
virtual IHelpHandler
 &handleEventsFor       ( IFrameWindow* associatedWindow ),
 &stopHandlingEventsFor ( IFrameWindow* associatedWindow );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent  ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  keysHelpId            ( IEvent&                    event ),
  subitemNotFound       ( IHelpSubitemNotFoundEvent& event ),
  helpUndefined         ( IEvent&                    event ),
  handleError           ( IHelpErrorEvent&           event ),
  showTutorial          ( IHelpTutorialEvent&        event ),
  menuBarCommand        ( IHelpMenuBarEvent&         event ),
  hyperlinkSelect       ( IHelpHyperlinkEvent&       event ),
  controlSelect         ( IHelpNotifyEvent&          event );

virtual Boolean
  showContents          ( IHelpNotifyEvent&          event ),
  showCoverPage         ( IHelpNotifyEvent&          event ),
  showPage              ( IHelpNotifyEvent&          event ),
  swapPage              ( IHelpNotifyEvent&          event ),
  showHistory           ( IHelpNotifyEvent&          event ),
  showIndex             ( IHelpNotifyEvent&          event ),
  showSearchList        ( IHelpNotifyEvent&          event ),
  openLibrary           ( IHelpNotifyEvent&          event );

private:
/*--------------------------------- Private ----------------------------------*/

/*------------------------------ Hidden Members ------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

}; // IHelpHandler

#pragma pack()

#endif /* IHELPHDR */
