/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IHP_H
#define _IHP_H

#include <iahp.h>
#include <iichp.h>
#include <iivhp.h>
#include <iihplst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGHeap;

template <class Element, class ElementOps>
class IGHeapCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGHeap
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapCursor
                            (IGHeap
                              <
                               Element, ElementOps> const&);

  IGHeapCursor <Element, ElementOps>&
           operator=        (IGHeapCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGHeap :
  public IAHeap <Element> {
protected:

  typedef  IGHeap <Element, ElementOps> Self;

  typedef  IHeapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapTypedef (Element, ElementOps);

public:

  typedef  IGHeapCursor
            <Element, ElementOps> Cursor;


           IGHeap
                            (INumber = 100);

           IGHeap
                            (IGHeap
                              <
                               Element, ElementOps> const&);

  IGHeap <Element, ElementOps>&
           operator=        (IGHeap
                              <
                               Element, ElementOps> const&);


protected:

           IGHeap
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeap
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapCursor
            <Element, ElementOps>;



};

template <class Element>
class IHeap :
  public IGHeap
          <Element, IStdOps <Element> > {

  typedef  IGHeap
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IHeap <Element> Self;

#define IHeapTypedef(Element)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IHeap
                            (INumber = 100);


protected:

           IHeap
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGHeap :
  public IGHeap
          <Element, ElementOps > {

  typedef  IVGHeap
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapTypedef (Element, ElementOps);

public:

           IVGHeap
                            (INumber = 100);


protected:

           IVGHeap
                              (PureImplementation&);

private:


};

template <class Element>
class IVHeap :
  public IVGHeap
          <Element, IStdOps <Element> > {

  typedef  IVGHeap
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVHeap <Element> Self;

#define IVHeapTypedef(Element)\
  typedef  IVHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVHeap
                            (INumber = 100);


protected:

           IVHeap
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ihp.inl>

#pragma info (restore)
#pragma pack ()

#endif
