/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGHeapCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeapCursor <Element, ElementOps>::
IGHeapCursor
  (IGHeap
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGHeapCursor <Element, ElementOps>&
IGHeapCursor <Element, ElementOps>::
operator=
  (IGHeapCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeapCursor <Element, ElementOps>::
IGHeapCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGHeap
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeap <Element, ElementOps>::
IGHeap (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGHeap <Element, ElementOps>::
IGHeap
  (IGHeap
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGHeap <Element, ElementOps>&
IGHeap <Element, ElementOps>::
operator= (IGHeap
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeap <Element, ElementOps>::
IGHeap (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGHeap
 <Element, ElementOps>::Implementation&
IGHeap <Element, ElementOps>::
ImplOf (IGHeap
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IHeap
// ---

// public members

template <class Element>
inline
IHeap <Element>::
IHeap (INumber numberOfElements)
: IGHeap
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IHeap <Element>::
IHeap (PureImplementation& impl)
: IGHeap
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGHeap
// ---

// public members

template <class Element, class ElementOps>
inline
IVGHeap <Element, ElementOps>::
IVGHeap (INumber numberOfElements)
: IGHeap
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGHeap <Element, ElementOps>::
IVGHeap (PureImplementation& impl)
: IGHeap
    <Element, ElementOps> (impl)
{
}

// ---
// IVHeap
// ---

// public members

template <class Element>
inline
IVHeap <Element>::
IVHeap (INumber numberOfElements)
: IVGHeap
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVHeap <Element>::
IVHeap (PureImplementation& impl)
: IVGHeap
   <Element, IStdOps <Element> > (impl)
{
}
