/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IHPDIL_H
#define _IHPDIL_H

#include <iahp.h>
#include <iichp.h>
#include <iivhp.h>
#include <iihpdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGHeapAsDilTable;

template <class Element, class ElementOps>
class IGHeapAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGHeapAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapAsDilTableCursor
                            (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsDilTableCursor <Element, ElementOps>&
           operator=        (IGHeapAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGHeapAsDilTable :
  public IAHeap <Element> {
protected:

  typedef  IGHeapAsDilTable <Element, ElementOps> Self;

  typedef  IHeapAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapAsDilTableTypedef(Element, ElementOps)\
  typedef  IHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGHeapAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGHeapAsDilTable
                            (INumber = 100);

           IGHeapAsDilTable
                            (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsDilTable <Element, ElementOps>&
           operator=        (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGHeapAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IHeapAsDilTable :
  public IGHeapAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGHeapAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IHeapAsDilTable <Element> Self;

#define IHeapAsDilTableTypedef(Element)\
  typedef  IHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IHeapAsDilTable
                            (INumber = 100);


protected:

           IHeapAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGHeapAsDilTable :
  public IGHeapAsDilTable
          <Element, ElementOps > {

  typedef  IVGHeapAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapAsDilTableTypedef(Element, ElementOps)\
  typedef  IHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapAsDilTableTypedef (Element, ElementOps);

public:

           IVGHeapAsDilTable
                            (INumber = 100);


protected:

           IVGHeapAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVHeapAsDilTable :
  public IVGHeapAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGHeapAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVHeapAsDilTable <Element> Self;

#define IVHeapAsDilTableTypedef(Element)\
  typedef  IVHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVHeapAsDilTable
                            (INumber = 100);


protected:

           IVHeapAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ihpdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
