/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGHeapAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeapAsListCursor <Element, ElementOps>::
IGHeapAsListCursor
  (IGHeapAsList
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGHeapAsListCursor <Element, ElementOps>&
IGHeapAsListCursor <Element, ElementOps>::
operator=
  (IGHeapAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeapAsListCursor <Element, ElementOps>::
IGHeapAsListCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGHeapAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeapAsList <Element, ElementOps>::
IGHeapAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGHeapAsList <Element, ElementOps>::
IGHeapAsList
  (IGHeapAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGHeapAsList <Element, ElementOps>&
IGHeapAsList <Element, ElementOps>::
operator= (IGHeapAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeapAsList <Element, ElementOps>::
IGHeapAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGHeapAsList
 <Element, ElementOps>::Implementation&
IGHeapAsList <Element, ElementOps>::
ImplOf (IGHeapAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IHeapAsList
// ---

// public members

template <class Element>
inline
IHeapAsList <Element>::
IHeapAsList (INumber numberOfElements)
: IGHeapAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IHeapAsList <Element>::
IHeapAsList (PureImplementation& impl)
: IGHeapAsList
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGHeapAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGHeapAsList <Element, ElementOps>::
IVGHeapAsList (INumber numberOfElements)
: IGHeapAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGHeapAsList <Element, ElementOps>::
IVGHeapAsList (PureImplementation& impl)
: IGHeapAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVHeapAsList
// ---

// public members

template <class Element>
inline
IVHeapAsList <Element>::
IVHeapAsList (INumber numberOfElements)
: IVGHeapAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVHeapAsList <Element>::
IVHeapAsList (PureImplementation& impl)
: IVGHeapAsList
   <Element, IStdOps <Element> > (impl)
{
}
