/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// -----------
// ICursorImpl
// -----------

// public members

inline
ICursorImpl::
ICursorImpl (IACollectionImpl const& collection)
: ivCollection (&collection)
{
}

inline
ICursorImpl::
~ICursorImpl ()
{
}

inline void const*
ICursorImpl::
Element () const
{ return ivCollection->ElementAt (*this);
}

inline IBoolean
ICursorImpl::
IsFor (IACollectionImpl const& collection) const
{ return (ivCollection == &collection);
}

inline IPosition
ICursorImpl::
Position () const
{ return ivCollection->PositionAt (*this);
}

inline IBoolean
ICursorImpl::
SetToFirst ()
{ return ivCollection->SetToFirst (*this);
}

inline IBoolean
ICursorImpl::
SetToLast ()
{ return ivCollection->SetToLast (*this);
}

inline IBoolean
ICursorImpl::
SetToNext ()
{ return ivCollection->SetToNext (*this);
}

inline void
ICursorImpl::
SetToPosition (IPosition position)
{ ivCollection->SetToPosition (position, *this);
}

inline IBoolean
ICursorImpl::
SetToPrevious ()
{ return ivCollection->SetToPrevious (*this);
}

inline IBoolean
ICursorImpl::
operator== (ICursorImpl const& cursor) const
{ return (ivCollection == cursor.ivCollection);
}

inline IBoolean
ICursorImpl::
operator!= (ICursorImpl const& cursor) const
{ return ! operator== (cursor);
}

// protected members

inline void*
ICursorImpl::
CheckPointer (void* ptr)
{ return IACollectionImpl::CheckPointer (ptr);
}

// ----------------
// IACollectionImpl
// ----------------

// public members

inline IBoolean
IACollectionImpl::
Add (void const* element)
{ return Add (element, *ivDummyCursor);
}

inline void
IACollectionImpl::
AddAsFirst (void const* element)
{ AddAsFirst (element, CursorOf (*this));
}

inline void
IACollectionImpl::
AddAsLast (void const* element)
{ AddAsLast (element, CursorOf (*this));
}

inline void
IACollectionImpl::
AddAtPosition (IPosition position, void const* element)
{ AddAtPosition (position, element, CursorOf (*this));
}

inline IBoolean
IACollectionImpl::
AddOrReplaceElementWithKey (void const* element)
{ return AddOrReplaceElementWithKey (element, CursorOf (*this));
}

inline IBoolean
IACollectionImpl::
Contains (void const* element) const
{ return Locate (element, CursorOf (*this));
}

inline IBoolean
IACollectionImpl::
LocateOrAdd (void const* element)
{ return LocateOrAdd (element, CursorOf (*this));
}

inline IBoolean
IACollectionImpl::
LocateOrAddElementWithKey (void const* element)
{ return LocateOrAddElementWithKey (element, CursorOf (*this));
}

inline IBoolean
IACollectionImpl::
ReplaceElementWithKey (void const* element)
{ return ReplaceElementWithKey (element, CursorOf (*this));
}

// protected members

inline
IACollectionImpl::
IACollectionImpl (IACollectionImpl const&)
{ // should never be executed
}

inline ICursorImpl&
IACollectionImpl::
CursorOf (IACollectionImpl const& collection)
{ return *collection.ivDummyCursor;
}

inline IACollectionImpl::Ops&
IACollectionImpl::
OpsOf (IACollectionImpl const& collection)
{ return *collection.ivOps;
}
