/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIAREL_H
#define _IIAREL_H

#include <iiacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class IARelationImpl : public IACollectionImpl {
public:

          ~IARelationImpl
                            ();

  virtual
  void     Antivalence      (IARelationImpl const&);

  virtual
  void     AddAntivalence   (IARelationImpl const&,
                             IARelationImpl const&); 

  virtual
  void     AddDifference    (IARelationImpl const&,
                             IARelationImpl const&); 

  virtual
  void     AddIntersection  (IARelationImpl const&,
                             IARelationImpl const&);

  virtual
  void     AddUnion         (IARelationImpl const&,
                             IARelationImpl const&);

  virtual
  void     Difference       (IARelationImpl const&);

  virtual
  void     Intersection     (IARelationImpl const&);

  virtual
  void     Union            (IARelationImpl const&);

  virtual
  IBoolean operator==       (IARelationImpl const&) const = 0;

  IBoolean operator!=       (IARelationImpl const&) const;

protected:

           IARelationImpl
                            (Ops&);

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  INumber  RemoveAllOccurrences
                            (void const*);

private:


};

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
