/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIASS_H
#define _IIASS_H

#include <iiacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class IASortedSetImpl : public IACollectionImpl {
public:

          ~IASortedSetImpl
                            ();

  virtual
  void     Antivalence      (IASortedSetImpl const&);

  virtual
  void     AddAntivalence   (IASortedSetImpl const&,
                             IASortedSetImpl const&); 

  virtual
  void     AddDifference    (IASortedSetImpl const&,
                             IASortedSetImpl const&); 

  virtual
  void     AddIntersection  (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  virtual
  void     AddUnion         (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  virtual
  long     Compare          (IASortedSetImpl const&,
                             ICompFunc, void*) const;

  virtual
  void     Difference       (IASortedSetImpl const&);

  virtual
  void     Intersection     (IASortedSetImpl const&);

  virtual
  void     Union            (IASortedSetImpl const&);

  virtual
  IBoolean operator==       (IASortedSetImpl const&) const = 0;

  IBoolean operator!=       (IASortedSetImpl const&) const;

protected:

           IASortedSetImpl
                            (Ops&);

  INumber  NumberOfOccurrences
                            (void const*) const;

  INumber  RemoveAllOccurrences
                            (void const*);

private:


};

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
