/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIATREE_H
#define _IIATREE_H

#include <iiglobal.h>
#include <iexctxt.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

enum ITreeIterationOrder {
  IPreorder,
  IPostorder
};

#pragma SOMAsDefault (off)

class IATreeImpl;

class ITreeCursorImpl {
public:

           ITreeCursorImpl  (IATreeImpl const&);

  virtual ~ITreeCursorImpl  ();

  virtual
  ITreeCursorImpl*
           Clone            () const = 0;

  virtual
  void     Copy             (ITreeCursorImpl const&) = 0;

  void const*
           Element          () const;

  virtual
  void     Invalidate       () = 0;

  IBoolean IsFor            (IATreeImpl const&) const;

  virtual
  IBoolean IsValid          () const = 0;

  IBoolean SetToChild       (IPosition);

  IBoolean SetToFirstExistingChild
                            ();

  IBoolean SetToLastExistingChild
                            ();

  IBoolean SetToNextExistingChild
                            ();

  IBoolean SetToParent      ();

  IBoolean SetToPreviousExistingChild
                            ();

  IBoolean SetToRoot        ();

  void     operator=        (ITreeCursorImpl const&);

  virtual
  IBoolean operator==       (ITreeCursorImpl const&) const = 0;

  IBoolean operator!=       (ITreeCursorImpl const&) const;

protected:

  IATreeImpl const*
           ivTree;

  static
  void*    CheckPointer     (void*);

private:


};

class IATreeOps;

class IATreeImpl {
public :

  typedef  IATreeOps Ops;

          ~IATreeImpl       ();

  virtual
  void     AddAsChild       (ITreeCursorImpl const&,
                             IPosition, void const*) = 0;

  virtual
  void     AddAsRoot        (void const*) = 0;

  virtual
  IBoolean AllElementsDo    (IApplFunc, ITreeIterationOrder, void*) = 0;

  virtual
  IBoolean AllSubtreeElementsDo
                            (ITreeCursorImpl const&, IApplFunc,
                             ITreeIterationOrder, void*) = 0;

  static
  void*    CheckPointer     (void*);

  virtual
  INumber  ChildPositionAt  (ITreeCursorImpl const&) const = 0;

  virtual
  char const*
           ClassName        () const = 0;

  virtual
  IATreeImpl*
           Clone            () const = 0;

  virtual
  ITreeCursorImpl*
           CreateCursor     () const = 0;

  void     Delete           ();

  virtual
  void*    ElementAt        (ITreeCursorImpl const&) const = 0;

  void     Initialize       ();

  virtual
  IBoolean IsConsistent     () const = 0;

  virtual
  IBoolean IsEmpty          () const;

  virtual
  IBoolean IsLeaf           (ITreeCursorImpl const&) const = 0;

  virtual
  IBoolean IsRoot           (ITreeCursorImpl const&) const = 0;

  void     LockBeforeReading
                            (long = -1);

  void     LockBeforeWriting
                            (long = -1);

  virtual
  INumber  NumberOfElements () const = 0;

  virtual
  INumber  NumberOfLeaves   () const = 0;

  virtual
  INumber  NumberOfSubtreeElements
                            (ITreeCursorImpl const&) const = 0;

  virtual
  INumber  NumberOfSubtreeLeaves
                            (ITreeCursorImpl const&) const = 0;

  virtual
  INumber  RemoveAll        () = 0;

  virtual
  INumber  RemoveSubtree    (ITreeCursorImpl&) = 0;

  virtual
  void     ReplaceAt        (ITreeCursorImpl const&, void const*) = 0;

  virtual
  IBoolean SetToChild       (IPosition, ITreeCursorImpl&) const = 0;

  virtual
  IBoolean SetToFirst       (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  IBoolean SetToFirstExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  IBoolean SetToLast        (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  IBoolean SetToLastExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  IBoolean SetToNext        (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  IBoolean SetToNextExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  IBoolean SetToParent      (ITreeCursorImpl&) const = 0;

  virtual
  IBoolean SetToPrevious    (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  IBoolean SetToPreviousExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  IBoolean SetToRoot        (ITreeCursorImpl&) const = 0;

  void     UnlockAfterReading
                            ();

  void     UnlockAfterWriting
                            ();

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

protected:

           IATreeImpl       (Ops&);

           IATreeImpl       (IATreeImpl const&);

  static
  Ops&     OpsOf            (IATreeImpl const&);

private:

  static
  ICollectionExceptionText
           cvExceptionText;

  Ops*     ivOps;

  INumber  ivReferenceCount;


};

class IATreeOps {
public:

  virtual ~IATreeOps        ();

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iiatree.inl>

#pragma info (restore)
#pragma pack ()

#endif
