/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---------------
// ITreeCursorImpl
// ---------------

// public members

inline
ITreeCursorImpl::
ITreeCursorImpl (IATreeImpl const& tree)
: ivTree (&tree)
{
}

inline
ITreeCursorImpl::
~ITreeCursorImpl ()
{
}

inline void const*
ITreeCursorImpl::
Element () const
{ return ivTree->ElementAt (*this);
}

inline IBoolean
ITreeCursorImpl::
IsFor (IATreeImpl const& tree) const
{ return (ivTree == &tree);
}

inline IBoolean
ITreeCursorImpl::
SetToChild (IPosition position)
{ return ivTree->SetToChild (position, *this);
}

inline IBoolean
ITreeCursorImpl::
SetToFirstExistingChild ()
{ return ivTree->SetToFirstExistingChild (*this);
}

inline IBoolean
ITreeCursorImpl::
SetToLastExistingChild ()
{ return ivTree->SetToLastExistingChild (*this);
}

inline IBoolean
ITreeCursorImpl::
SetToNextExistingChild ()
{ return ivTree->SetToNextExistingChild (*this);
}

inline IBoolean
ITreeCursorImpl::
SetToParent ()
{ return ivTree->SetToParent (*this);
}

inline IBoolean
ITreeCursorImpl::
SetToPreviousExistingChild ()
{ return ivTree->SetToPreviousExistingChild (*this);
}

inline IBoolean
ITreeCursorImpl::
SetToRoot ()
{ return ivTree->SetToRoot (*this);
}

inline void
ITreeCursorImpl::
operator= (ITreeCursorImpl const& cursor)
{ ivTree = cursor.ivTree;
}

inline IBoolean
ITreeCursorImpl::
operator== (ITreeCursorImpl const& cursor) const
{ return (ivTree == cursor.ivTree);
}

inline IBoolean
ITreeCursorImpl::
operator!= (ITreeCursorImpl const& cursor) const
{ return ! operator== (cursor);
}

// protected members

inline void*
ITreeCursorImpl::
CheckPointer (void* ptr)
{ return IATreeImpl::CheckPointer (ptr);
}

// ----------
// IATreeImpl
// ----------

// public members

inline
IATreeImpl::
~IATreeImpl ()
{
}

// protected members

inline
IATreeImpl::
IATreeImpl (Ops& ops)
: ivOps (&ops), ivReferenceCount (0)
{
}

inline
IATreeImpl::
IATreeImpl (IATreeImpl const&)
{ // should never be executed
}

inline IATreeImpl::Ops&
IATreeImpl::
OpsOf (IATreeImpl const& tree)
{ return *tree.ivOps;
}
