/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIBAGHSH_H
#define _IIBAGHSH_H

#include <iibagkb.h>


#include <iikbhsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IBagOnKeyBagImpl
         <IKeyBagAsHshTableImpl> IBagAsHshTableImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsHshTableImpl> IABagAsHshTableOps;

template <class Element, class ElementOps, class Implementation>
class IBagAsHshTableOps :
  public IABagAsHshTableOps {

  typedef  IABagAsHshTableOps Inherited;

  typedef  IBagAsHshTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsHshTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsHshTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsHshTableOps
                           (INumber);

           IBagAsHshTableOps
                           (INumber, void*);

           IBagAsHshTableOps
                           (IBagAsHshTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsHshTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsHshTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iibaghsh.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
