/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIBAGKB_H
#define _IIBAGKB_H

#include <iiabag.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IBagOnKeyBagMngCursorImpl;

template <class Base>
class IBagOnKeyBagImpl;

template <class Base>
class IBagOnKeyBagMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IBagOnKeyBagMngCursorImpl
                            (IBagOnKeyBagImpl <Base> const&);


          ~IBagOnKeyBagMngCursorImpl
                             ();

protected:

private:


};

template <class Base>
class IABagOnKeyBagOps;


template <class Base>
class IBagOnKeyBagImpl : public IABagImpl {

  typedef  IABagImpl Inherited;

  typedef  IBagOnKeyBagImpl <Base> Self;

public:

  typedef  IABagOnKeyBagOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IBagOnKeyBagMngCursorImpl <Base> MngCursor;

           IBagOnKeyBagImpl (Ops&, INumber);

           IBagOnKeyBagImpl (Ops&, IBagOnKeyBagImpl <Base> const&);

          ~IBagOnKeyBagImpl ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfDifferentElements
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextDifferentElement
                            (ICursorImpl&) const;

  void     operator=        (IBagOnKeyBagImpl <Base> const&);

  IBoolean operator==       (IABagImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IBagOnKeyBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IBagOnKeyBagImpl <Base> const&);

  friend
  class    IBagOnKeyBagMngCursorImpl <Base>;


};

template <class Base>
class IABagOnKeyBagOps {
public:

  virtual ~IABagOnKeyBagOps ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

  // for backward compatibility
           IABagOnKeyBagOps (IBoolean);

private:


};

#pragma SOMAsDefault (pop)

#include <iibagkb.inl>


#pragma info (restore)
#pragma pack ()

#endif
