/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// ICHeapImpl
// ---

// public members

template <class CInherited>
ICHeapImpl <CInherited>::
ICHeapImpl (Ops& ops, INumber numberOfElements)
: CInherited (ops, numberOfElements)
{
}

template <class CInherited>
ICHeapImpl <CInherited>::
ICHeapImpl
  (Ops& ops, ICHeapImpl <CInherited> const& collection)
: CInherited (ops, collection)
{
}

template <class CInherited>
IBoolean
ICHeapImpl <CInherited>::
Add (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor      (ClassName (), "Add")

  IBoolean hasBeenAdded = CInherited::Add (element, cursor);
  return hasBeenAdded;
}

template <class CInherited>
void
ICHeapImpl <CInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ ICHECK_Identical (ClassName (), "AddAllFrom")

  CInherited::AddAllFrom (collection);
}

template <class CInherited>
void*
ICHeapImpl <CInherited>::
Any () const
{ ICHECK_IsEmpty (ClassName (), "Any")

  return CInherited::Any ();
}

template <class CInherited>
void*
ICHeapImpl <CInherited>::
ElementAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (ClassName (), "ElementAt")
  ICHECK_IsValid      (ClassName (), "ElementAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "ElementAt")
#endif

  return CInherited::ElementAt (cursor);
}

template <class CInherited>
void
ICHeapImpl <CInherited>::
RemoveAt (ICursorImpl& cursor)
{ ICHECK_IsFor        (ClassName (), "RemoveAt")
  ICHECK_IsValid      (ClassName (), "RemoveAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "RemoveAt")
#endif

  CInherited::RemoveAt (cursor);
}

template <class CInherited>
void
ICHeapImpl <CInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ ICHECK_IsFor        (ClassName (), "ReplaceAt")
  ICHECK_IsValid      (ClassName (), "ReplaceAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "ReplaceAt")
#endif

  CInherited::ReplaceAt (cursor, element);
}

template <class CInherited>
IBoolean
ICHeapImpl <CInherited>::
SetToFirst (ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "SetToFirst")

  return CInherited::SetToFirst (cursor);
}

template <class CInherited>
IBoolean
ICHeapImpl <CInherited>::
SetToNext (ICursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToNext")
  ICHECK_IsValid (ClassName (), "SetToNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToNext")
#endif

  return CInherited::SetToNext (cursor);
}

#pragma info (restore)
#pragma pack ()
