/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIESDIL_H
#define _IIESDIL_H

#include <iiesseq.h>


#include <iiseqdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IEqualitySequenceOnSequenceImpl
         <ISequenceAsDilTableImpl> IEqualitySequenceAsDilTableImpl;

typedef IAEqualitySequenceOnSequenceOps
         <ISequenceAsDilTableImpl> IAEqualitySequenceAsDilTableOps;

template <class Element, class ElementOps, class Implementation>
class IEqualitySequenceAsDilTableOps :
  public IAEqualitySequenceAsDilTableOps {

  typedef  IEqualitySequenceAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, ISequenceAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IEqualitySequenceAsDilTableOps
                           (INumber);

           IEqualitySequenceAsDilTableOps
                           (INumber, void*);

           IEqualitySequenceAsDilTableOps
                           (IEqualitySequenceAsDilTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IEqualitySequenceAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  IBoolean EqualElements   (void const*, void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator ISequenceAsDilTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iiesdil.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
