/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIESSEQ_H
#define _IIESSEQ_H

#include <iiaes.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IEqualitySequenceOnSequenceMngCursorImpl;

template <class Base>
class IEqualitySequenceOnSequenceImpl;

template <class Base>
class IEqualitySequenceOnSequenceMngCursorImpl :
  public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IEqualitySequenceOnSequenceMngCursorImpl
                            (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

          ~IEqualitySequenceOnSequenceMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IAEqualitySequenceOnSequenceOps;

template <class Base>
class IEqualitySequenceOnSequenceImpl : public IAEqualitySequenceImpl {

  typedef  IAEqualitySequenceImpl Inherited;

  typedef  IEqualitySequenceOnSequenceImpl <Base> Self;

public:

  typedef  IAEqualitySequenceOnSequenceOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IEqualitySequenceOnSequenceMngCursorImpl <Base> MngCursor;

           IEqualitySequenceOnSequenceImpl
                            (Ops&, INumber);

           IEqualitySequenceOnSequenceImpl
                            (Ops&,
                             IEqualitySequenceOnSequenceImpl
                              <Base> const&);

          ~IEqualitySequenceOnSequenceImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateFirst      (void const*, ICursorImpl&) const;

  IBoolean LocateLast       (void const*, ICursorImpl&) const;

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean LocatePrevious   (void const*, ICursorImpl&) const;

  INumber  NumberOfElements () const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  void     Reverse          ();

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

  IBoolean operator==       (IAEqualitySequenceImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  void const*
           ivElement;

#pragma SOMAsDefault (off)

  struct Predicate {

    typedef  IEqualitySequenceOnSequenceImpl <Base> ES;

    static
    IBoolean IsEqual          (void const*, void*);

  };

#pragma SOMAsDefault (pop)

  static
  Base&    BaseOf           (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

  friend
  class    IEqualitySequenceOnSequenceMngCursorImpl <Base>;

  friend
  struct   Predicate;


};

template <class Base>
class IAEqualitySequenceOnSequenceOps {
public:

  virtual ~IAEqualitySequenceOnSequenceOps
                            ();

  virtual
  IBoolean EqualElements    (void const*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iiesseq.inl>


#pragma info (restore)
#pragma pack ()

#endif
