/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIESTAB_H
#define _IIESTAB_H

#include <iiesseq.h>


#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IEqualitySequenceOnSequenceImpl
         <ISequenceAsTableImpl> IEqualitySequenceAsTableImpl;

typedef IAEqualitySequenceOnSequenceOps
         <ISequenceAsTableImpl> IAEqualitySequenceAsTableOps;

template <class Element, class ElementOps, class Implementation>
class IEqualitySequenceAsTableOps :
  public IAEqualitySequenceAsTableOps {

  typedef  IEqualitySequenceAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IEqualitySequenceAsTableOps
                           (INumber);

           IEqualitySequenceAsTableOps
                           (INumber, void*);

           IEqualitySequenceAsTableOps
                           (IEqualitySequenceAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IEqualitySequenceAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  IBoolean EqualElements   (void const*, void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iiestab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
