/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIHPSEQ_H
#define _IIHPSEQ_H

#include <iiahp.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IHeapOnSequenceMngCursorImpl;

template <class Base>
class IHeapOnSequenceImpl;

template <class Base>
class IHeapOnSequenceMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IHeapOnSequenceMngCursorImpl
                            (IHeapOnSequenceImpl <Base> const&);

          ~IHeapOnSequenceMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IAHeapOnSequenceOps;

template <class Base>
class IHeapOnSequenceImpl : public IAHeapImpl {

  typedef  IAHeapImpl Inherited;

  typedef  IHeapOnSequenceImpl <Base> Self;

public:

  typedef  IAHeapOnSequenceOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IHeapOnSequenceMngCursorImpl <Base> MngCursor;

           IHeapOnSequenceImpl
                            (Ops&, INumber);

           IHeapOnSequenceImpl
                            (Ops&, IHeapOnSequenceImpl <Base> const&);

          ~IHeapOnSequenceImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  INumber  NumberOfElements () const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     operator=        (IHeapOnSequenceImpl <Base> const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IHeapOnSequenceImpl <Base> const&);

  static
  Ops&     OpsOf            (IHeapOnSequenceImpl <Base> const&);

  friend
  class    IHeapOnSequenceMngCursorImpl <Base>;


};

template <class Base>
class IAHeapOnSequenceOps {
public:

  virtual ~IAHeapOnSequenceOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iihpseq.inl>


#pragma info (restore)
#pragma pack ()

#endif
