/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIHPTAB_H
#define _IIHPTAB_H

#include <iihpseq.h>


#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IHeapOnSequenceImpl
         <ISequenceAsTableImpl> IHeapAsTableImpl;

typedef IAHeapOnSequenceOps
         <ISequenceAsTableImpl> IAHeapAsTableOps;

template <class Element, class ElementOps, class Implementation>
class IHeapAsTableOps :
  public IAHeapAsTableOps {

  typedef  IHeapAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IHeapAsTableOps
                           (INumber);

           IHeapAsTableOps
                           (INumber, void*);

           IHeapAsTableOps
                           (IHeapAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IHeapAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iihptab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
