/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKBHSH_H
#define _IIKBHSH_H

#include <iiakb.h>
#include <stddef.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

struct IAKeyBagAsHshTableNodeImpl {

  IAKeyBagAsHshTableNodeImpl*
           ivNext;

           IAKeyBagAsHshTableNodeImpl
                            ();

};

template <class Element>
struct IKeyBagAsHshTableNodeImpl :
  public IAKeyBagAsHshTableNodeImpl {

  Element  ivElement;

           IKeyBagAsHshTableNodeImpl
                            (Element const&);

          ~IKeyBagAsHshTableNodeImpl
                            ();


};

#pragma SOMAsDefault (pop)
#pragma SOMAsDefault (off)

class IKeyBagAsHshTableCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  IKeyBagAsHshTableCursorImpl Self;

public:

           IKeyBagAsHshTableCursorImpl
                            (IACollectionImpl const&);

           IKeyBagAsHshTableCursorImpl
                            (IKeyBagAsHshTableCursorImpl const&);

          ~IKeyBagAsHshTableCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  IBoolean IsInBetween      () const;

  IBoolean IsValid          () const;

  void     operator=        (IKeyBagAsHshTableCursorImpl const&);

  IBoolean operator==       (ICursorImpl const&) const;

protected:

private:

  IAKeyBagAsHshTableNodeImpl*
           ivNode;

  INumber  ivBucket;

  friend
  class    IKeyBagAsHshTableImpl;


};


template <class Base>
class IKeySetOnKeyBagImpl;

class IAKeyBagAsHshTableOps;

class IKeyBagAsHshTableImpl : public IAKeyBagImpl {

  typedef  IAKeyBagImpl Inherited;

  typedef  IKeyBagAsHshTableImpl Self;

  typedef  IAKeyBagAsHshTableNodeImpl Node;

public:

  typedef  IAKeyBagAsHshTableOps Ops;

  typedef  IKeyBagAsHshTableCursorImpl Cursor;

  typedef  IKeyBagAsHshTableCursorImpl MngCursor;

           IKeyBagAsHshTableImpl
                            (Ops&, INumber);

           IKeyBagAsHshTableImpl
                            (Ops&, IKeyBagAsHshTableImpl const&);

          ~IKeyBagAsHshTableImpl
                            ();

  IBoolean Add              (void const* element, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  void*    Key              (void const*) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     operator=        (IKeyBagAsHshTableImpl const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNode       (void const*) const;

  void*    CreateNodes      (INumber) const;

  void     DeleteNode       (void*) const;

  void     DeleteNodes      (void*) const;

  IBoolean EqualKeys        (void const*, void const*,
                             IArgType) const;

  unsigned long
           HashKey          (void const*, unsigned long,
                             IArgType) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  Node**   ivTable;

  INumber  ivNumberOfBuckets;

  INumber  ivNumberOfElements;

  static
  INumber& BucketOf         (ICursorImpl const&);

  void     CopyFrom         (IKeyBagAsHshTableImpl const&);

  void*    ElementOf        (Node const*) const;

  void     GrowBy           (INumber);

  static
  INumber  FindNearestPrime (INumber);

  void     Initialize       (INumber);

  static
  IBoolean IsInBetween      (ICursorImpl const&);

  static
  INumber& NextBucketOf     (ICursorImpl const&);

  static
  Node*&   NextNodeOf       (ICursorImpl const&);

  static
  Node*&   NodeOf           (ICursorImpl const&);


  static
  Ops&     OpsOf            (IKeyBagAsHshTableImpl const&);

  void     SetInBetween     (MngCursor&) const;

  friend
  class    IKeyBagAsHshTableMngCursorImpl;

  friend
  class    IKeySetOnKeyBagImpl <Self>;


};

class IAKeyBagAsHshTableOps {
public:

  virtual ~IAKeyBagAsHshTableOps
                             ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNode       (void const*) const = 0;

  virtual
  void*    CreateNodes      (INumber) const = 0;

  virtual
  void     DeleteNode       (void*) const = 0;

  virtual
  void     DeleteNodes      (void*) const = 0;

  virtual
  IBoolean EqualKeys        (void const*, void const*,
                             IArgType) const = 0;

  virtual
  unsigned long
           HashKey          (void const*, unsigned long,
                             IArgType) const = 0;

  virtual
  void*    Key              (void const*) const = 0;

  virtual
  void*    StreamIn         (TStream&) const = 0;

  virtual
  void     StreamOut        (void const*, TStream&) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

protected:

           IAKeyBagAsHshTableOps
                            (IBoolean);

private:

  IBoolean ivContainsDTSObjects;

  friend
  class    IKeyBagAsHshTableImpl;


};

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IKeyBagAsHshTableOps : public IAKeyBagAsHshTableOps {

  typedef  IAKeyBagAsHshTableOps Inherited;

  typedef  IKeyBagAsHshTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeyBagAsHshTableNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeyBagAsHshTableOps
                            (INumber);

           IKeyBagAsHshTableOps
                            (INumber, void*);

           IKeyBagAsHshTableOps
                            (IKeyBagAsHshTableOps
                              <Element, _Key,
                               ElementOps, Implementation> const&);

          ~IKeyBagAsHshTableOps
                            ();

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  void*    CreateNode       (void const*) const;

  void*    CreateNodes      (INumber) const;

  void     DeleteNode       (void*) const;

  void     DeleteNodes      (void*) const;

  IBoolean EqualKeys        (void const*, void const*,
                             IArgType) const;

  unsigned long
           HashKey          (void const*, unsigned long,
                             IArgType) const;

  void*    Key              (void const*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

           operator Implementation*
                            ();


protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#include <iikbhsh.inl>

#if ! defined (__TEMPINC__)
#include <iikbhsh.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
