/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

// --------------------------
// IAKeyBagAsHshTableNodeImpl
// --------------------------

// public members

inline
IAKeyBagAsHshTableNodeImpl::
IAKeyBagAsHshTableNodeImpl ()
: ivNext (0)
{
}

// -------------------------
// IKeyBagAsHshTableNodeImpl
// -------------------------

// public members

template <class Element>
inline
IKeyBagAsHshTableNodeImpl <Element>::
IKeyBagAsHshTableNodeImpl (Element const& element)
: IAKeyBagAsHshTableNodeImpl (), ivElement (element)
{
}

template <class Element>
inline
IKeyBagAsHshTableNodeImpl <Element>::
~IKeyBagAsHshTableNodeImpl ()
{
}

// ---------------------------
// IKeyBagAsHshTableCursorImpl
// ---------------------------

// public members

inline void
IKeyBagAsHshTableCursorImpl::
Invalidate ()
{ ivNode = 0;
}

inline IBoolean
IKeyBagAsHshTableCursorImpl::
IsInBetween () const
{ return false;
}

inline IBoolean
IKeyBagAsHshTableCursorImpl::
IsValid () const
{ return (ivNode != 0);
}

inline void
IKeyBagAsHshTableCursorImpl::
operator= (IKeyBagAsHshTableCursorImpl const& cursor)
{ Inherited::operator= (cursor);
  ivNode   = cursor.ivNode;
  ivBucket = cursor.ivBucket;
}

inline IBoolean
IKeyBagAsHshTableCursorImpl::
operator== (ICursorImpl const& cursor) const
{ return (Inherited::operator== (cursor) &&
          ivNode   == ((Self const&)cursor).ivNode &&
          ivBucket == ((Self const&)cursor).ivBucket);
}



// ---------------------
// IKeyBagAsHshTableImpl
// ---------------------

// public members


// ---------------------
// IAKeyBagAsHshTableOps
// ---------------------

// public members

inline
IAKeyBagAsHshTableOps::
~IAKeyBagAsHshTableOps ()
{
}

// protected members

inline
IAKeyBagAsHshTableOps::
IAKeyBagAsHshTableOps (IBoolean containsDTSObjects)
: ivContainsDTSObjects (containsDTSObjects)
{
}
