/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKBLST_H
#define _IIKBLST_H

#include <iikbksb.h>


#include <iiksblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeyBagOnKeySortedBagImpl
         <IKeySortedBagAsListImpl> IKeyBagAsListImpl;

typedef IAKeyBagOnKeySortedBagOps
         <IKeySortedBagAsListImpl> IAKeyBagAsListOps;

template <class Element, class Key,
          class ElementOps, class Implementation>
class IKeyBagAsListOps :
  public IAKeyBagAsListOps {

  typedef  IKeyBagAsListOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsListOps
            <Element, Key,
             ElementOps, IKeySortedBagAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeyBagAsListOps
                           (INumber);

           IKeyBagAsListOps
                           (INumber, void*);

           IKeyBagAsListOps
                           (IKeyBagAsListOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeyBagAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iikblst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
