/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSAVL_H
#define _IIKSAVL_H

#include <iikskss.h>


#include <iikssavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsAvlTreeImpl> IKeySetAsAvlTreeImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsAvlTreeImpl> IAKeySetAsAvlTreeOps;

template <class Element, class Key,
          class ElementOps, class Implementation>
class IKeySetAsAvlTreeOps :
  public IAKeySetAsAvlTreeOps {

  typedef  IKeySetAsAvlTreeOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsAvlTreeOps
            <Element, Key,
             ElementOps, IKeySortedSetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsAvlTreeOps
                           (INumber);

           IKeySetAsAvlTreeOps
                           (INumber, void*);

           IKeySetAsAvlTreeOps
                           (IKeySetAsAvlTreeOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iiksavl.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
