/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSBST_H
#define _IIKSBST_H

#include <iikskss.h>


#include <iikssbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsBstTreeImpl> IKeySetAsBstTreeImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsBstTreeImpl> IAKeySetAsBstTreeOps;

template <class Element, class Key,
          class ElementOps, class Implementation>
class IKeySetAsBstTreeOps :
  public IAKeySetAsBstTreeOps {

  typedef  IKeySetAsBstTreeOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsBstTreeOps
            <Element, Key,
             ElementOps, IKeySortedSetAsBstTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsBstTreeOps
                           (INumber);

           IKeySetAsBstTreeOps
                           (INumber, void*);

           IKeySetAsBstTreeOps
                           (IKeySetAsBstTreeOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsBstTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsBstTreeImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iiksbst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
