/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSHSH_H
#define _IIKSHSH_H

#include <iikskb.h>


#include <iikbhsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySetOnKeyBagImpl
         <IKeyBagAsHshTableImpl> IKeySetAsHshTableImpl;

typedef IAKeySetOnKeyBagOps
         <IKeyBagAsHshTableImpl> IAKeySetAsHshTableOps;

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IKeySetAsHshTableOps :
  public IAKeySetAsHshTableOps {

  typedef  IKeySetAsHshTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeyBagAsHshTableOps
            <Element, _Key,
             ElementOps, IKeyBagAsHshTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySetAsHshTableOps
                           (INumber);

           IKeySetAsHshTableOps
                           (INumber, void*);

           IKeySetAsHshTableOps
                           (IKeySetAsHshTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsHshTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsHshTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iikshsh.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
