/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSKB_H
#define _IIKSKB_H

#include <iiaks.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IKeySetOnKeyBagMngCursorImpl;

template <class Base>
class IKeySetOnKeyBagImpl;

template <class Base>
class IKeySetOnKeyBagMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IKeySetOnKeyBagMngCursorImpl
                            (IKeySetOnKeyBagImpl <Base> const&);

          ~IKeySetOnKeyBagMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IBagOnKeySetImpl;

template <class Base>
class IAKeySetOnKeyBagOps;

template <class Base>
class IKeySetOnKeyBagImpl : public IAKeySetImpl {

  typedef  IAKeySetImpl Inherited;

  typedef  IKeySetOnKeyBagImpl <Base> Self;

public:

  typedef  IAKeySetOnKeyBagOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IKeySetOnKeyBagMngCursorImpl <Base> MngCursor;

           IKeySetOnKeyBagImpl
                            (Ops&, INumber);

           IKeySetOnKeyBagImpl
                            (Ops&, IKeySetOnKeyBagImpl <Base> const&);

          ~IKeySetOnKeyBagImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const* ) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  ICursorImpl*
           CreateCursor     () const;

  ICursorImpl*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  void*    Key              (void const*) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     operator=        (IKeySetOnKeyBagImpl <Base> const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualKeys        (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IKeySetOnKeyBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IKeySetOnKeyBagImpl <Base> const&);

  friend
  class    IKeySetOnKeyBagMngCursorImpl <Base>;

  friend
  class    IBagOnKeySetImpl <Self>;


};

template <class Base>
class IAKeySetOnKeyBagOps {
public:

  virtual ~IAKeySetOnKeyBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iikskb.inl>


#pragma info (restore)
#pragma pack ()

#endif
