/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSLST_H
#define _IIKSLST_H

#include <iikskss.h>


#include <iiksslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsListImpl> IKeySetAsListImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsListImpl> IAKeySetAsListOps;

template <class Element, class Key,
          class ElementOps, class Implementation>
class IKeySetAsListOps :
  public IAKeySetAsListOps {

  typedef  IKeySetAsListOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsListOps
            <Element, Key,
             ElementOps, IKeySortedSetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsListOps
                           (INumber);

           IKeySetAsListOps
                           (INumber, void*);

           IKeySetAsListOps
                           (IKeySetAsListOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iikslst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
