/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSSAVL_H
#define _IIKSSAVL_H

#include <iiakss.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)


#pragma SOMAsDefault (off)

typedef short Direction;

const short kAvlLeft  = -1;
const short kAvlNone  =  0;
const short kAvlRight =  1;

struct IAKeySortedSetAsAvlTreeNodeImpl {

  IAKeySortedSetAsAvlTreeNodeImpl
          *ivLeft,
          *ivRight,
          *ivParent;

  Direction
           ivDeeperSubtree;

           IAKeySortedSetAsAvlTreeNodeImpl
                            ();

  IAKeySortedSetAsAvlTreeNodeImpl*&
           Link             (Direction);

  void     Parent           (IAKeySortedSetAsAvlTreeNodeImpl*&,
                             Direction&);

  void     ConnectChild     (Direction,
                             IAKeySortedSetAsAvlTreeNodeImpl*);

  void     ConnectChild0    (Direction,
                             IAKeySortedSetAsAvlTreeNodeImpl*);

};

template <class Element>
struct IKeySortedSetAsAvlTreeNodeImpl :
  public IAKeySortedSetAsAvlTreeNodeImpl {

  Element  ivElement;

           IKeySortedSetAsAvlTreeNodeImpl
                            (Element const&);

          ~IKeySortedSetAsAvlTreeNodeImpl
                            ();


};

#pragma SOMAsDefault (pop)
#pragma SOMAsDefault (off)

class IKeySortedSetAsAvlTreeCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  IKeySortedSetAsAvlTreeCursorImpl Self;

public:

           IKeySortedSetAsAvlTreeCursorImpl
                            (IACollectionImpl const&);

           IKeySortedSetAsAvlTreeCursorImpl
                            (IKeySortedSetAsAvlTreeCursorImpl const&);

          ~IKeySortedSetAsAvlTreeCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  IBoolean IsInBetween      () const;

  IBoolean IsValid          () const;

  void     operator=        (IKeySortedSetAsAvlTreeCursorImpl const&);

  IBoolean operator==       (ICursorImpl const&) const;

protected:

private:

  IAKeySortedSetAsAvlTreeNodeImpl*
           ivNode;

  friend
  class    IKeySortedSetAsAvlTreeImpl;


};


template <class Base>
class IKeySetOnKeySortedSetImpl;

template <class Base>
class ISortedBagOnKeySortedSetImpl;

template <class Base>
class ISortedMapOnKeySortedSetImpl;

class IAKeySortedSetAsAvlTreeOps;

class IKeySortedSetAsAvlTreeImpl : public IAKeySortedSetImpl {

  typedef  IAKeySortedSetImpl Inherited;

  typedef  IKeySortedSetAsAvlTreeImpl Self;

  typedef  IAKeySortedSetAsAvlTreeNodeImpl Node;

public:

  typedef  IAKeySortedSetAsAvlTreeOps Ops;

  typedef  IKeySortedSetAsAvlTreeCursorImpl Cursor;

  typedef  IKeySortedSetAsAvlTreeCursorImpl MngCursor;

           IKeySortedSetAsAvlTreeImpl
                            (Ops&, INumber);

           IKeySortedSetAsAvlTreeImpl
                            (Ops&, IKeySortedSetAsAvlTreeImpl const&);

          ~IKeySortedSetAsAvlTreeImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     operator=        (IKeySortedSetAsAvlTreeImpl const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNode       (void const*) const;

  long     CompareKeys      (void const*, void const*,
                             IArgType) const;

  void     DeleteNode       (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  Node*    ivRoot;

  INumber  ivNumberOfElements;

  void     AddAllFromSubtree
                            (Node const*);

  IBoolean AllElementsDoSubtree
                            (IApplFunc, void*, Node*) const;

  void     Balance          (Node*, Direction, IBoolean&);

  IBoolean CheckNode        (Node const*, Node*) const;

  IBoolean ContainsAllKeysFromSubtree
                            (Node const*) const;

  Node*    CopySubtree      (Node const*) const;

  void     DeleteSubtree    (Node*) const;

  void     DisconnectAndRemove
                            (Node*, IBoolean&);

  void*    ElementOf        (Node const*) const;

  IBoolean IsConsistentSubtree
                            (Node const*, int&, INumber&) const;

  static
  IBoolean IsInBetween      (ICursorImpl const&);

  static
  Node*&   NextNodeOf       (ICursorImpl const&);

  static
  Node*&   NodeOf           (ICursorImpl const&);

  static
  Ops&     OpsOf            (IKeySortedSetAsAvlTreeImpl const&);

  static
  Node*&   PreviousNodeOf   (ICursorImpl const&);

  void     ReplaceNode      (Node*, Node*);

  void     SetInBetween     (MngCursor&) const;

  friend
  class    IKeySortedSetAsAvlTreeMngCursorImpl;

  friend
  class    IKeySetOnKeySortedSetImpl <Self>;

  friend
  class    ISortedBagOnKeySortedSetImpl <Self>;

  friend
  class    ISortedMapOnKeySortedSetImpl <Self>;


};

class IAKeySortedSetAsAvlTreeOps {
public:

  virtual ~IAKeySortedSetAsAvlTreeOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  long     CompareKeys      (void const*, void const*,
                             IArgType) const = 0;

  virtual
  void*    CreateNode       (void const*) const = 0;

  virtual
  void     DeleteNode       (void*) const = 0;

  virtual
  void*    Key              (void const*) const = 0;

  virtual
  void*    StreamIn         (TStream&) const = 0;

  virtual
  void     StreamOut        (void const*, TStream&) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

protected:

           IAKeySortedSetAsAvlTreeOps
                            (IBoolean);

private:

  IBoolean ivContainsDTSObjects;

  friend
  class    IKeySortedSetAsAvlTreeImpl;


};

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IKeySortedSetAsAvlTreeOps : public IAKeySortedSetAsAvlTreeOps {

  typedef  IAKeySortedSetAsAvlTreeOps Inherited;

  typedef  IKeySortedSetAsAvlTreeOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsAvlTreeNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedSetAsAvlTreeOps
                            (INumber);

           IKeySortedSetAsAvlTreeOps
                            (INumber, void*);

           IKeySortedSetAsAvlTreeOps
                            (IKeySortedSetAsAvlTreeOps
                              <Element, _Key,
                               ElementOps, Implementation> const&);

          ~IKeySortedSetAsAvlTreeOps
                            ();

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  long     CompareKeys      (void const*, void const*, IArgType) const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

  void*    Key              (void const*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

           operator Implementation*
                            ();


protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#include <iikssavl.inl>

#if ! defined (__TEMPINC__)
#include <iikssavl.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
