/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

// -------------------------------
// IAKeySortedSetAsAvlTreeNodeImpl
// -------------------------------

// public members

inline
IAKeySortedSetAsAvlTreeNodeImpl::
IAKeySortedSetAsAvlTreeNodeImpl ()
: ivLeft (0), ivRight (0), ivParent (0), ivDeeperSubtree (kAvlNone)
{
}


// ------------------------------
// IKeySortedSetAsAvlTreeNodeImpl
// ------------------------------

// public members

template <class Element>
inline
IKeySortedSetAsAvlTreeNodeImpl <Element>::
IKeySortedSetAsAvlTreeNodeImpl (Element const& element)
: IAKeySortedSetAsAvlTreeNodeImpl (), ivElement (element)
{
}

template <class Element>
inline
IKeySortedSetAsAvlTreeNodeImpl <Element>::
~IKeySortedSetAsAvlTreeNodeImpl ()
{
}

// --------------------------------
// IKeySortedSetAsAvlTreeCursorImpl
// --------------------------------

// public members

inline void
IKeySortedSetAsAvlTreeCursorImpl::
Invalidate ()
{ ivNode = 0;
}

inline IBoolean
IKeySortedSetAsAvlTreeCursorImpl::
IsInBetween () const
{ return false;
}

inline IBoolean
IKeySortedSetAsAvlTreeCursorImpl::
IsValid () const
{ return (ivNode != 0);
}

inline void
IKeySortedSetAsAvlTreeCursorImpl::
operator= (IKeySortedSetAsAvlTreeCursorImpl const& cursor)
{ Inherited::operator= (cursor);
  ivNode = cursor.ivNode;
}

inline IBoolean
IKeySortedSetAsAvlTreeCursorImpl::
operator== (ICursorImpl const& cursor) const
{ return (Inherited::operator== (cursor) &&
          ivNode == ((Self const&)cursor).ivNode);
}


// --------------------------
// IKeySortedSetAsAvlTreeImpl
// --------------------------

// public members


// --------------------------
// IAKeySortedSetAsAvlTreeOps
// --------------------------

// public members

inline
IAKeySortedSetAsAvlTreeOps::
~IAKeySortedSetAsAvlTreeOps ()
{
}

// protected members

inline
IAKeySortedSetAsAvlTreeOps::
IAKeySortedSetAsAvlTreeOps (IBoolean containsDTSObjects)
: ivContainsDTSObjects (containsDTSObjects)
{
}
