/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <new.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// -------------------------
// IKeySortedSetAsBstTreeOps
// -------------------------

// public members

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
IKeySortedSetAsBstTreeOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivElementOps (),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
IKeySortedSetAsBstTreeOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivElementOps (opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
IKeySortedSetAsBstTreeOps
  (IKeySortedSetAsBstTreeOps
    <Element, Key,
     ElementOps, Implementation, nodeSize> const& collection)
: Inherited (__isDTSClass (Element)),
  ivElementOps (collection.ivElementOps),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
~IKeySortedSetAsBstTreeOps ()
{
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
Assign (void* element1, void const* element2) const
{ ivElementOps.Assign (*(Element*)element1,
                       *(Element const*)element2);
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IACollectionImpl*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
long
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CompareKeys (void const* arg1, void const* arg2, IArgType argType) const
{ long comp;
  switch (argType) {
    case kElementElement: {
      comp = ivElementOps.keyOps.Compare
        (ivElementOps.Key (*(Element const*)arg1),
         ivElementOps.Key (*(Element const*)arg2));
      break;
    }
    case kElementKey: {
      comp = ivElementOps.keyOps.Compare
        (ivElementOps.Key (*(Element const*)arg1),
         IKeyForOps ((Key const*)arg2));
      break;
    }
    case kKeyKey: {
      comp = ivElementOps.keyOps.Compare
        (IKeyForOps ((Key const*)arg1), IKeyForOps ((Key const*)arg2));
      break;
    }
  }
  return comp;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
long
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CompareKeys (void const* key, INumber index,
             void const* arg, IArgType argType) const
{ long comp;
  switch (argType) {
    case kKey: {
      comp = ivElementOps.keyOps.Compare
        (((Key const*)key) [index], IKeyForOps ((Key const*)arg));
      break;
    }
    case kElement: {
      comp = ivElementOps.keyOps.Compare
        (((Key const*)key) [index],
         ivElementOps.Key (*(Element const*)arg));
      break;
    }
  }
  return comp;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void 
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CopyKey (void* to, INumber toIndex,
         void const* from, INumber fromIndex) const
{ ((Key*)to) [toIndex] = ((Key*)from) [fromIndex];
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CreateINode (void const* inode) const
{ void* node = ivElementOps.Allocate (sizeof (INode)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
                                     );
  ivImpl.CheckPointer (node);

  if (inode == 0) {
    node = new (node) INode;
  }
  else {
    node = new (node) INode (*(INode*)inode);

    for (INumber i = 0; i < ((INode*)node)->ivm; i++)
      ((INode*)node)->ivPtrs [i] = ((INode*)inode)->ivPtrs [i];
    for (i = 0; i < ((INode*)node)->ivm - 1; i++)
      ((INode*)node)->ivKeys [i] = ((INode*)inode)->ivKeys [i];
  }
  return node;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CreateKey () const
{ return new Key;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CreateLNode (void const* element) const
{ void* node = ivElementOps.Allocate (sizeof (LNode)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
                                     );
  return
    new (ivImpl.CheckPointer (node)) LNode (*(Element const*)element);
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
DeleteINode (void* inode) const
{ ((INode*)inode)->~INode ();
  ivElementOps.Deallocate (inode
#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif
                          );
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
DeleteKey (void* key) const
{ delete (Key*)key;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
DeleteLNode (void* lnode) const
{ ((LNode*)lnode)->~LNode ();
  ivElementOps.Deallocate (lnode
#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif
                          );
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
Key (void const* element) const
{ return IKeyFromOps (ivElementOps.Key (*(Element const*)element));
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
StreamIn (TStream& fromWhere) const
{ Element* element = ivElementOps.GetStreamable ();
  ivElementOps.StreamIn (*element, fromWhere);
  return (void*) element;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
StreamOut (void const* element, TStream& toWhere) const
{ ivElementOps.StreamOut (*(Element const*)element, toWhere);
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
TStream&
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
operator<<= (TStream& fromWhere)
{ return (ivElementOps <<= fromWhere);
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
TStream&
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
operator>>= (TStream& toWhere) const
{ return (ivElementOps >>= toWhere);
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
operator INumber () const
{ return IBSTORDER;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#pragma info (restore)
#pragma pack ()
