/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSSBST_H
#define _IIKSSBST_H

#include <iiakss.h>
#include <stddef.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

struct IAKeySortedSetAsBstTreeNodeImpl {

  IBoolean ivIsLeaf;

};

struct IAKeySortedSetAsBstTreeINodeImpl :
  public IAKeySortedSetAsBstTreeNodeImpl {

  void*    ivKeys;

  IAKeySortedSetAsBstTreeNodeImpl**
           ivPtrs;

  INumber  ivm;

           IAKeySortedSetAsBstTreeINodeImpl
                            ();

           IAKeySortedSetAsBstTreeINodeImpl
                            (IAKeySortedSetAsBstTreeINodeImpl const&);
};

#define IBSTMAX(a,b)  ((a) < (b) ? (b) : (a))

#if ! defined (IBSTORDER)
#define IBSTORDER \
  IBSTMAX ((long)3, (((long)nodeSize) \
                   - (sizeof (IAKeySortedSetAsBstTreeINodeImpl) \
                    + sizeof (IAKeySortedSetAsBstTreeNodeImpl*)) \
                   ) / (sizeof (Key) \
                    + sizeof (IAKeySortedSetAsBstTreeNodeImpl*)) + 1)
#endif

template <class Key, size_t nodeSize>
struct IKeySortedSetAsBstTreeINodeImpl :
  public IAKeySortedSetAsBstTreeINodeImpl {

  typedef  IAKeySortedSetAsBstTreeINodeImpl Inherited;

  IAKeySortedSetAsBstTreeNodeImpl*
           ivPtrs [IBSTORDER];

  Key      ivKeys [IBSTORDER - 1];

           IKeySortedSetAsBstTreeINodeImpl
                            ();

           IKeySortedSetAsBstTreeINodeImpl
                            (IKeySortedSetAsBstTreeINodeImpl
                              <Key, nodeSize > const&);

          ~IKeySortedSetAsBstTreeINodeImpl
                            ();



};

struct IAKeySortedSetAsBstTreeLNodeImpl :
  public IAKeySortedSetAsBstTreeNodeImpl {
};

template <class Element>
struct IKeySortedSetAsBstTreeLNodeImpl :
  public IAKeySortedSetAsBstTreeLNodeImpl {

  Element  ivElement;

           IKeySortedSetAsBstTreeLNodeImpl
                            (Element const&);

          ~IKeySortedSetAsBstTreeLNodeImpl
                            ();


};

#pragma SOMAsDefault (pop)
#pragma SOMAsDefault (off)

class IKeySortedSetAsBstTreeCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  IKeySortedSetAsBstTreeCursorImpl Self;

public:

           IKeySortedSetAsBstTreeCursorImpl
                            (IACollectionImpl const&);

           IKeySortedSetAsBstTreeCursorImpl
                            (IKeySortedSetAsBstTreeCursorImpl const&);

          ~IKeySortedSetAsBstTreeCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  IBoolean IsInBetween      () const;

  IBoolean IsValid          () const;

  void     operator=        (IKeySortedSetAsBstTreeCursorImpl const&);

  IBoolean operator==       (ICursorImpl const&) const;

protected:

private:

  IAKeySortedSetAsBstTreeNodeImpl*
           ivNode;

  friend
  class    IKeySortedSetAsBstTreeImpl;


};


template <class Base>
class IKeySetOnKeySortedSetImpl;

template <class Base>
class ISortedBagOnKeySortedSetImpl;

template <class Base>
class ISortedMapOnKeySortedSetImpl;

class IAKeySortedSetAsBstTreeOps;

class IKeySortedSetAsBstTreeImpl : public IAKeySortedSetImpl {

  typedef  IAKeySortedSetImpl Inherited;

  typedef  IKeySortedSetAsBstTreeImpl Self;

  typedef  IAKeySortedSetAsBstTreeNodeImpl   Node;

  typedef  IAKeySortedSetAsBstTreeINodeImpl INode;

  typedef  IAKeySortedSetAsBstTreeLNodeImpl LNode;

public:

  typedef  IAKeySortedSetAsBstTreeOps Ops;

  typedef  IKeySortedSetAsBstTreeCursorImpl Cursor;

  typedef  IKeySortedSetAsBstTreeCursorImpl MngCursor;

           IKeySortedSetAsBstTreeImpl
                            (Ops&, INumber);

           IKeySortedSetAsBstTreeImpl
                            (Ops&, IKeySortedSetAsBstTreeImpl const&);

          ~IKeySortedSetAsBstTreeImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     operator=        (IKeySortedSetAsBstTreeImpl const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  void     Assign           (void*, void const*) const;

  long     CompareKeys      (void const*, void const*,
                             IArgType) const;

  long     CompareKeys      (void const*, INumber, void const*,
                             IArgType) const;

  void     CopyKey          (void*, INumber,
                             void const*, INumber) const;

  void*    CreateINode      (void const* = 0) const;

  void*    CreateKey        () const;

  void*    CreateLNode      (void const*) const;

  void     DeleteINode      (void*) const;

  void     DeleteKey        (void*) const;

  void     DeleteLNode      (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  Node*    ivRoot;

  INumber  ivNumberOfElements;

  INumber  ivTreeOrder;

  INumber  ivHeight;

  IBoolean AddSubtree       (Node*, void const*,
                             Node*&, void*, ICursorImpl&);

  void     AddAllFromSubtree
                            (Node const*);

  IBoolean AllElementsDoSubtree
                            (IApplFunc, void*, Node*);

  INumber  BinarySearchInPageWithKey
                            (INode const*, void const*) const;

  INumber  BinarySearchInPageWithElement
                            (INode const*, void const*) const;


  IBoolean CheckCursorSubtree
                            (ICursorImpl const&, Node const*) const;

  IBoolean ContainsAllKeysFromSubtree
                            (Node const*) const;

  Node*    CopySubtree      (Node const*) const;

  INumber  DeleteSubtree    (Node*) const;

  void*    ElementOf        (LNode const*) const;

  IBoolean IsConsistentSubtree
                            (Node const*) const;

  static
  IBoolean IsInBetween      (ICursorImpl const&);

  void     JoinINodes       (INode*, INode*, INode*, INumber);


  IBoolean LocateElementWithKeySubtree
                            (void const*, ICursorImpl&, Node*) const;

  static
  LNode*   MinimumLeaf      (Node*);

  static
  LNode*   MaximumLeaf      (Node*);

  static
  Node*&   NextNodeOf       (ICursorImpl const&);

  static
  Node*&   NodeOf           (ICursorImpl const&);

  static
  Ops&     OpsOf            (IKeySortedSetAsBstTreeImpl const&);

  static
  Node*&   PreviousNodeOf   (ICursorImpl const&);

  void     RemoveSubtree    (INode*, ICursorImpl&);

  void     SetInBetween     (MngCursor&) const;

  IBoolean SetToNextSubtree (ICursorImpl&, INode const*) const;

  IBoolean SetToPreviousSubtree
                            (ICursorImpl&, INode const*) const;

  friend
  class    IKeySortedSetAsBstTreeMngCursorImpl;

  friend
  class    IKeySetOnKeySortedSetImpl <Self>;

  friend
  class    ISortedBagOnKeySortedSetImpl <Self>;

  friend
  class    ISortedMapOnKeySortedSetImpl <Self>;


};

class IAKeySortedSetAsBstTreeOps {
public:

  virtual ~IAKeySortedSetAsBstTreeOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  long     CompareKeys      (void const*, void const*,
                             IArgType) const = 0;

  virtual
  long     CompareKeys      (void const*, INumber, void const*,
                             IArgType) const = 0;

  virtual
  void     CopyKey          (void*, INumber,
                             void const*, INumber) const = 0;

  virtual
  void*    CreateINode      (void const*) const = 0;

  virtual
  void*    CreateKey        () const = 0;

  virtual
  void*    CreateLNode      (void const*) const = 0;

  virtual
  void     DeleteINode      (void*) const = 0;

  virtual
  void     DeleteKey        (void*) const = 0;

  virtual
  void     DeleteLNode      (void*) const = 0;

  virtual
  void*    Key              (void const*) const = 0;

  virtual
  void*    StreamIn         (TStream&) const = 0;

  virtual
  void     StreamOut        (void const*, TStream&) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator INumber () const = 0;

protected:

           IAKeySortedSetAsBstTreeOps
                            (IBoolean);

private:

  IBoolean ivContainsDTSObjects;

  friend
  class    IKeySortedSetAsBstTreeImpl;


};

#if ! defined (IBSTPAGESIZE)
#define IBSTPAGESIZE 4096
#endif

template <class Element, class _Key,
          class ElementOps, class Implementation,
          size_t nodeSize = IBSTPAGESIZE>
class IKeySortedSetAsBstTreeOps : public IAKeySortedSetAsBstTreeOps {

  typedef  IAKeySortedSetAsBstTreeOps Inherited;

  typedef  IKeySortedSetAsBstTreeOps
            <Element, _Key, ElementOps, Implementation, nodeSize> Self;

  typedef  IKeySortedSetAsBstTreeINodeImpl <_Key, nodeSize> INode;

  typedef  IKeySortedSetAsBstTreeLNodeImpl <Element> LNode;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedSetAsBstTreeOps
                            (INumber);

           IKeySortedSetAsBstTreeOps
                            (INumber, void*);

           IKeySortedSetAsBstTreeOps
                            (IKeySortedSetAsBstTreeOps
                              <Element, _Key, ElementOps,
                               Implementation, nodeSize> const&);

          ~IKeySortedSetAsBstTreeOps
                            ();

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  long     CompareKeys      (void const*, void const*,
                             IArgType) const;

  long     CompareKeys      (void const*, INumber, void const*,
                             IArgType) const;

  void     CopyKey          (void*, INumber,
                             void const*, INumber) const;

  void*    CreateINode      (void const*) const;

  void*    CreateKey        () const;

  void*    CreateLNode      (void const*) const;

  void     DeleteINode      (void*) const;

  void     DeleteKey        (void*) const;

  void     DeleteLNode      (void*) const;

  void*    Key              (void const*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

           operator INumber () const;

           operator Implementation*
                            ();


protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#include <iikssbst.inl>

#if ! defined (__TEMPINC__)
#include <iikssbst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
