/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

// --------------------------------
// IAKeySortedSetAsBstTreeINodeImpl
// --------------------------------

// public members

inline
IAKeySortedSetAsBstTreeINodeImpl::
IAKeySortedSetAsBstTreeINodeImpl ()
: ivm (0)
{
}

inline
IAKeySortedSetAsBstTreeINodeImpl::
IAKeySortedSetAsBstTreeINodeImpl
  (IAKeySortedSetAsBstTreeINodeImpl const& inode)
: ivm (inode.ivm)
{
}

// -------------------------------
// IKeySortedSetAsBstTreeINodeImpl
// -------------------------------

// public members

template <class Key, size_t nodeSize>
inline
IKeySortedSetAsBstTreeINodeImpl <Key, nodeSize>::
IKeySortedSetAsBstTreeINodeImpl ()
{ ivIsLeaf = false;
  Inherited::ivPtrs = ivPtrs;
  Inherited::ivKeys = ivKeys;
}

template <class Key, size_t nodeSize>
inline
IKeySortedSetAsBstTreeINodeImpl <Key, nodeSize>::
IKeySortedSetAsBstTreeINodeImpl
  (IKeySortedSetAsBstTreeINodeImpl <Key, nodeSize > const& inode)
: Inherited (inode)
{ ivIsLeaf = false;
  Inherited::ivPtrs = ivPtrs;
  Inherited::ivKeys = ivKeys;
}

template <class Key, size_t nodeSize>
inline
IKeySortedSetAsBstTreeINodeImpl <Key, nodeSize>::
~IKeySortedSetAsBstTreeINodeImpl ()
{
}

// -------------------------------
// IKeySortedSetAsBstTreeLNodeImpl
// -------------------------------

// public members

template <class Element>
inline
IKeySortedSetAsBstTreeLNodeImpl <Element>::
IKeySortedSetAsBstTreeLNodeImpl (Element const& element)
: ivElement (element)
{ ivIsLeaf = true;
}

template <class Element>
inline
IKeySortedSetAsBstTreeLNodeImpl <Element>::
~IKeySortedSetAsBstTreeLNodeImpl ()
{
}

// --------------------------------
// IKeySortedSetAsBstTreeCursorImpl
// --------------------------------

// public members

inline void
IKeySortedSetAsBstTreeCursorImpl::
Invalidate ()
{ ivNode = 0;
}

inline IBoolean
IKeySortedSetAsBstTreeCursorImpl::
IsValid () const
{ return (ivNode != 0);
}

inline IBoolean
IKeySortedSetAsBstTreeCursorImpl::
IsInBetween () const
{ return false;
}

inline void
IKeySortedSetAsBstTreeCursorImpl::
operator= (IKeySortedSetAsBstTreeCursorImpl const& cursor)
{ Inherited::operator= (cursor);
  ivNode = cursor.ivNode;
}

inline IBoolean
IKeySortedSetAsBstTreeCursorImpl::
operator== (ICursorImpl const& cursor) const
{ return (Inherited::operator== (cursor) &&
          ivNode == ((Self const&)cursor).ivNode);
}


// --------------------------
// IKeySortedSetAsBstTreeImpl
// --------------------------

// public members


// --------------------------
// IAKeySortedSetAsBstTreeOps
// --------------------------

// public members

inline
IAKeySortedSetAsBstTreeOps::
~IAKeySortedSetAsBstTreeOps ()
{
}

// protected members

inline
IAKeySortedSetAsBstTreeOps::
IAKeySortedSetAsBstTreeOps (IBoolean containsDTSObjects)
: ivContainsDTSObjects (containsDTSObjects)
{
}
