/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSSTAB_H
#define _IIKSSTAB_H

#include <iikssseq.h>


#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySortedSetOnSequenceImpl
         <ISequenceAsTableImpl> IKeySortedSetAsTableImpl;

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IKeySortedSetAsTableOps :
  public IAKeySortedSetOnSequenceOps <ISequenceAsTableImpl> {

  typedef  IKeySortedSetAsTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedSetAsTableOps
                           (INumber);

           IKeySortedSetAsTableOps
                           (INumber, void*);

           IKeySortedSetAsTableOps
                           (IKeySortedSetAsTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySortedSetAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  long     CompareKeys     (void const*, void const*, IArgType) const;

  void*    Key             (void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iiksstab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
