/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIMAPBST_H
#define _IIMAPBST_H

#include <iimapks.h>


#include <iiksbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IMapOnKeySetImpl
         <IKeySetAsBstTreeImpl> IMapAsBstTreeImpl;

typedef IAMapOnKeySetOps
         <IKeySetAsBstTreeImpl> IAMapAsAsBstTreeOps;

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IMapAsBstTreeOps :
  public IAMapAsAsBstTreeOps {

  typedef  IMapAsBstTreeOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySetAsBstTreeOps
            <Element, _Key,
             ElementOps, IKeySetAsBstTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IMapAsBstTreeOps
                           (INumber);

           IMapAsBstTreeOps
                           (INumber, void*);

           IMapAsBstTreeOps
                           (IMapAsBstTreeOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IMapAsBstTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

  IBoolean EqualElements    (void const*, void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator IKeySetAsBstTreeImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iimapbst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
