/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIMAPKS_H
#define _IIMAPKS_H

#include <iiamap.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IMapOnKeySetMngCursorImpl;

template <class Base>
class IMapOnKeySetImpl;

template <class Base>
class IMapOnKeySetMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IMapOnKeySetMngCursorImpl
                            (IMapOnKeySetImpl <Base> const&);

          ~IMapOnKeySetMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IAMapOnKeySetOps;

template <class Base>
class IMapOnKeySetImpl : public IAMapImpl {

  typedef  IAMapImpl Inherited;

  typedef  IMapOnKeySetImpl <Base> Self;

public:

  typedef  IAMapOnKeySetOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IMapOnKeySetMngCursorImpl <Base> MngCursor;

           IMapOnKeySetImpl (Ops&, INumber);

           IMapOnKeySetImpl (Ops&, IMapOnKeySetImpl <Base> const&);

          ~IMapOnKeySetImpl ();

  IBoolean Add              (void const*, ICursorImpl&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  void*    Key              (void const*) const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     operator=        (IMapOnKeySetImpl <Base> const&);

  IBoolean operator==       (IAMapImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IMapOnKeySetImpl <Base> const&);

  static
  Ops&     OpsOf            (IMapOnKeySetImpl <Base> const&);

  friend
  class    IMapOnKeySetMngCursorImpl <Base>;


};

template <class Base>
class IAMapOnKeySetOps {
public:

  virtual ~IAMapOnKeySetOps ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  IBoolean EqualElements    (void const*, void const*) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iimapks.inl>


#pragma info (restore)
#pragma pack ()

#endif
