/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IITREE_H
#define _IITREE_H

#include <iiatree.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

struct IAMultiwayTreeNodeImpl {

  IAMultiwayTreeNodeImpl*
            ivParent;

  IAMultiwayTreeNodeImpl**
            ivChildren;

};

template <INumber numOfChildren, class Element>
struct IMultiwayTreeNodeImpl : public IAMultiwayTreeNodeImpl {

  typedef   IAMultiwayTreeNodeImpl Inherited;

  Element   ivElement;

  IAMultiwayTreeNodeImpl*
            ivChildren [numOfChildren];

            IMultiwayTreeNodeImpl
                             (Element const&);

           ~IMultiwayTreeNodeImpl
                             ();

};

#pragma SOMAsDefault (pop)

#pragma SOMAsDefault (off)

class IMultiwayTreeCursorImpl : public ITreeCursorImpl {

  typedef  ITreeCursorImpl Inherited;

  typedef  IMultiwayTreeCursorImpl Self;

public:

           IMultiwayTreeCursorImpl
                            (IATreeImpl const&);

           IMultiwayTreeCursorImpl
                            (IMultiwayTreeCursorImpl const&);

          ~IMultiwayTreeCursorImpl
                            ();

  ITreeCursorImpl*
           Clone            () const;

  void     Copy             (ITreeCursorImpl const&);

  IBoolean IsValid          () const;

  void     Invalidate       ();

  void     operator=        (IMultiwayTreeCursorImpl const&);

  IBoolean operator==       (ITreeCursorImpl const&) const;

protected:

private:

  IAMultiwayTreeNodeImpl*
           ivNode;

  friend
  class    IMultiwayTreeImpl;


};

class IAMultiwayTreeOps;

class IMultiwayTreeImpl : public IATreeImpl {

  typedef  IATreeImpl Inherited;

  typedef  IMultiwayTreeImpl Self;

  typedef  IAMultiwayTreeNodeImpl Node;

public :

  typedef  IAMultiwayTreeOps Ops;

  typedef  IMultiwayTreeCursorImpl Cursor;

  typedef  IMultiwayTreeCursorImpl MngCursor;

           IMultiwayTreeImpl
                            (Ops&);

           IMultiwayTreeImpl
                            (Ops&, IMultiwayTreeImpl const&);

          ~IMultiwayTreeImpl
                            ();

  void     AddAsChild       (ITreeCursorImpl const&,
                             IPosition, void const*);

  void     AddAsRoot        (void const*);

  IBoolean AllElementsDo    (IApplFunc, ITreeIterationOrder, void*);

  IBoolean AllSubtreeElementsDo
                            (ITreeCursorImpl const&,
                             IApplFunc, ITreeIterationOrder, void*);

  virtual
  void     AttachAsChild    (ITreeCursorImpl const&,
                             IPosition, IMultiwayTreeImpl&);

  virtual
  void     AttachAsRoot     (IMultiwayTreeImpl&);

  virtual
  void     AttachSubtreeAsChild
                            (ITreeCursorImpl const&, IPosition,
                             IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  virtual
  void     AttachSubtreeAsRoot
                            (IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  IBoolean CheckChild       (ITreeCursorImpl const&, IPosition) const;

  IBoolean CheckCursor      (ITreeCursorImpl const&) const;

  IBoolean CheckCursor      (ITreeCursorImpl const&,
                             ITreeCursorImpl const&) const;

  INumber  ChildPositionAt  (ITreeCursorImpl const&) const;

  char const*
           ClassName        () const;

  IATreeImpl*
           Clone            () const;

  void     Copy             (IMultiwayTreeImpl const&);

  virtual
  void     CopySubtree      (IMultiwayTreeImpl const&,
                             ITreeCursorImpl const&);

  Cursor*  CreateCursor     () const;

  void*    ElementAt        (ITreeCursorImpl const&) const;

  virtual
  IBoolean HasChild         (IPosition, ITreeCursorImpl const&) const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsLeaf           (ITreeCursorImpl const&) const;

  IBoolean IsRoot           (ITreeCursorImpl const&) const;

  INumber  NumberOfChildren () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfLeaves   () const;

  INumber  NumberOfSubtreeElements
                            (ITreeCursorImpl const&) const;

  INumber  NumberOfSubtreeLeaves
                            (ITreeCursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveSubtree    (ITreeCursorImpl&);

  void     ReplaceAt        (ITreeCursorImpl const&, void const*);

  IBoolean SetToChild       (IPosition, ITreeCursorImpl&) const;

  IBoolean SetToFirst       (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToFirstExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToLast        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToLastExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToNext        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToNextExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToParent      (ITreeCursorImpl&) const;

  IBoolean SetToPrevious    (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToPreviousExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToRoot        (ITreeCursorImpl&) const;

  void     operator=        (IMultiwayTreeImpl const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  Node*    ivRoot;

  INumber  ivNumberOfChildren;

  IBoolean AllElementsDoSubtree
                            (IApplFunc,
                             ITreeIterationOrder, void*, Node*);

  IBoolean CheckCursorSubtree
                            (ITreeCursorImpl const&, Node*) const;

  Node*    CopySubtree      (Node const*) const;

  INumber  DeleteSubtree    (Node*) const;

  void*    ElementOf        (Node const*) const;

  void     InitNode         (Node*, Node*) const;

  IBoolean IsConsistentSubtree
                            (Node*) const;

  static
  Node*&   NodeOf           (ITreeCursorImpl const&);

  INumber  NumberOfSubtreeElements
                            (Node const*) const;

  INumber  NumberOfSubtreeLeaves
                            (Node const*) const;

  static
  Ops&     OpsOf            (IMultiwayTreeImpl const&);

  Node*    StreamInSubtree  (TStream&) const;

  void     StreamOutSubtree (Node const*, TStream&) const;


};

class IAMultiwayTreeOps {
public:

  virtual ~IAMultiwayTreeOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IATreeImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNode       (void const*) const = 0;

  virtual
  void     DeleteNode       (void*) const = 0;

  virtual
  void*    StreamIn         (TStream&) const = 0;

  virtual
  void     StreamOut        (void const*, TStream&) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator INumber () const = 0;

protected:

           IAMultiwayTreeOps
                            (IBoolean);

private:

  IBoolean ivContainsDTSObjects;

  friend
  class    IMultiwayTreeImpl;


};

template <INumber numOfChildren, class Element,
          class ElementOps, class Implementation>
class IMultiwayTreeOps : public IAMultiwayTreeOps {

  typedef  IAMultiwayTreeOps Inherited;

  typedef  IMultiwayTreeOps <numOfChildren, Element,
                             ElementOps, Implementation> Self;

  typedef  IMultiwayTreeNodeImpl <numOfChildren, Element> Node;

public:

           IMultiwayTreeOps ();

           IMultiwayTreeOps (void*);

           IMultiwayTreeOps (IMultiwayTreeOps
                              <numOfChildren, Element,
                               ElementOps, Implementation> const&);

          ~IMultiwayTreeOps ();

  void     Assign           (void*, void const*) const;

  IATreeImpl*
           Clone            () const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

           operator INumber () const;

           operator Implementation*
                            ();


protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#include <iimwt.inl>

#if ! defined (__TEMPINC__)
#include <iimwt.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
