/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---------------------
// IMultiwayTreeNodeImpl
// ---------------------

// public members

template <INumber numOfChildren, class Element>
inline
IMultiwayTreeNodeImpl <numOfChildren, Element>::
IMultiwayTreeNodeImpl (Element const& element)
: ivElement (element)
{ Inherited::ivParent = 0;
  Inherited::ivChildren = ivChildren;
}

template <INumber numOfChildren, class Element>
inline
IMultiwayTreeNodeImpl <numOfChildren, Element>::
~IMultiwayTreeNodeImpl ()
{
}

// -----------------------
// IMultiwayTreeCursorImpl
// -----------------------

// public members

inline IBoolean
IMultiwayTreeCursorImpl::
IsValid () const
{ return (ivNode != 0);
}

inline void
IMultiwayTreeCursorImpl::
Invalidate ()
{ ivNode = 0;
}

inline void
IMultiwayTreeCursorImpl::
operator= (IMultiwayTreeCursorImpl const& cursor)
{ Inherited::operator= (cursor);
  ivNode = ((Self const&)cursor).ivNode;
}

inline IBoolean
IMultiwayTreeCursorImpl::
operator== (ITreeCursorImpl const& cursor) const
{ return (Inherited::operator== (cursor) &&
          ivNode == ((Self const&)cursor).ivNode);
}


// -----------------
// IAMultiwayTreeOps
// -----------------

// public members

inline
IAMultiwayTreeOps::
~IAMultiwayTreeOps ()
{
}

// protected members

inline
IAMultiwayTreeOps::
IAMultiwayTreeOps (IBoolean containsDTSObjects)
: ivContainsDTSObjects (containsDTSObjects)
{
}
