#ifndef _IINFOA_
  #define _IINFOA_
/*******************************************************************************
* FILE NAME: iinfoa.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IInfoArea                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <istattxt.hpp>
#include <imenuhdr.hpp>
#include <istring.hpp>

class IFrameWindow;
class IMenuEvent;
class IModuleHandle;
class IResourceLibrary;
class IInfoAreaData;

#pragma pack(4)
#pragma info(nocls)

class IInfoArea : public IStaticText, public IMenuHandler {
typedef IStaticText
  Inherited;
public:
/*------------------------------ Constructors --------------------------------*/
  IInfoArea ( IFrameWindow*        frame,
              unsigned long        id = 0 );
  IInfoArea ( IFrameWindow*        frame,
              unsigned long        id,
              const char*          resDLLName );

  IInfoArea ( IFrameWindow*        frame,
              const IModuleHandle& resMod,
              unsigned long        id = 0 );
  IInfoArea ( IFrameWindow*        frame,
              const char*          resDLLName,
              unsigned long        id = 0 );

virtual
 ~IInfoArea ( );

/*----------------------------- Resource Library -----------------------------*/
virtual IResourceLibrary
 &resourceLibrary       ( ) const;

virtual IInfoArea
 &setResourceLibrary    ( const IModuleHandle& resMod ),
 &setResourceLibrary    ( const char*          resDLLName );

/*--------------------------- String Table Offset ----------------------------*/
virtual long
  stringTableOffset     ( ) const;

virtual IInfoArea
 &setStringTableOffset  ( long newOffset = 0 );

/*----------------------- Special Information Strings ------------------------*/
virtual IString
  inactiveText          ( ) const,
  disabledText          ( ) const,
  missingText           ( ) const;

virtual IInfoArea
 &setInactiveText       ( unsigned long  inactiveText ),
 &setInactiveText       ( const IString& inactiveText ),
 &setDisabledText       ( unsigned long  disabledText ),
 &setDisabledText       ( const IString& disabledText ),
 &setMissingText        ( unsigned long  missingText ),
 &setMissingText        ( const IString& missingText );

/*------------------------------- Display Size -------------------------------*/
virtual unsigned long
  lineCount             ( ) const;
virtual IInfoArea
 &setLineCount          ( unsigned long lines = 1 );

/*-------------------------- Event Dispatching -------------------------------*/
virtual IInfoArea
 &handleEventsFor       ( IFrameWindow* frame ),
 &stopHandlingEventsFor ( IFrameWindow* frame );

/*--------------------------- Notification Members ---------------------------*/
// Attribute Change Notifications
static INotificationId const
  IC_IMPORTU inactiveTextId,
  IC_IMPORTU disabledTextId,
  IC_IMPORTU missingTextId,
  IC_IMPORTU resourceLibraryId;

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent(IEvent& event);

/*---------------------- Information String Processing -----------------------*/
virtual IString
  informationFor        ( unsigned long menuId ) const;

/*-------------------------- Menu Event Processing----------------------------*/
virtual Boolean
  menuSelected          ( IMenuEvent& menuEvent ),
  menuEnded             ( IMenuEvent& menuEvent );

/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize       ( ) const;

private:
/*----------------------------- Hidden Members -------------------------------*/
  IInfoArea  ( const IInfoArea& infoArea );
IInfoArea
 &operator=  ( const IInfoArea& infoArea );

/*--------------------------------- Private ----------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

enum IAStatus
  {
  noneShowing,
  missingShowing,
  inactiveShowing,
  disabledShowing
  };
void
  setString             ( IString&, unsigned long ),
  addTo                 ( IFrameWindow* ),
  showText              ( IAStatus newStatus, const IString& text );
IAStatus
  status;
IResourceLibrary
 *pResLib;
long
  strTblOffset;
unsigned long
  numberOfLines;
IString
  inactive,
  disabled,
  missing;
Boolean
  preventFlyUpdate;

IInfoAreaData
 *fInfoAreaData;
}; // class IInfoArea

#pragma info(restore)
#pragma pack()

#endif /* _IINFOA_ */
