/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIRELKB_H
#define _IIRELKB_H

#include <iiarel.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IRelationOnKeyBagMngCursorImpl;

template <class Base>
class IRelationOnKeyBagImpl;

template <class Base>
class IRelationOnKeyBagMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IRelationOnKeyBagMngCursorImpl
                            (IRelationOnKeyBagImpl <Base> const&);

          ~IRelationOnKeyBagMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IARelationOnKeyBagOps;

template <class Base>
class IRelationOnKeyBagImpl : public IARelationImpl {

  typedef  IARelationImpl Inherited;

  typedef  IRelationOnKeyBagImpl <Base> Self;

public:

  typedef  IARelationOnKeyBagOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IRelationOnKeyBagMngCursorImpl <Base> MngCursor;

           IRelationOnKeyBagImpl
                            (Ops&, INumber);

           IRelationOnKeyBagImpl
                            (Ops&, IRelationOnKeyBagImpl <Base> const&);

          ~IRelationOnKeyBagImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  void*    Key              (void const*) const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     operator=        (IRelationOnKeyBagImpl <Base> const&);

  IBoolean operator==       (IARelationImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IRelationOnKeyBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IRelationOnKeyBagImpl <Base> const&);

  friend
  class    IRelationOnKeyBagMngCursorImpl <Base>;


};

template <class Base>
class IARelationOnKeyBagOps {
public:

  virtual ~IARelationOnKeyBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  IBoolean EqualElements    (void const*, void const*) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iirelkb.inl>


#pragma info (restore)
#pragma pack ()

#endif
