/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISBKSB_H
#define _IISBKSB_H

#include <iiasb.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class ISortedBagOnKeySortedBagMngCursorImpl;

template <class Base>
class ISortedBagOnKeySortedBagImpl;

template <class Base>
class ISortedBagOnKeySortedBagMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           ISortedBagOnKeySortedBagMngCursorImpl
                            (ISortedBagOnKeySortedBagImpl <Base> const&);


          ~ISortedBagOnKeySortedBagMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IASortedBagOnKeySortedBagOps;

template <class Base>
class ISortedBagOnKeySortedBagImpl : public IASortedBagImpl {

  typedef  IASortedBagImpl Inherited;

  typedef  ISortedBagOnKeySortedBagImpl <Base> Self;

public:

  typedef  IASortedBagOnKeySortedBagOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  ISortedBagOnKeySortedBagMngCursorImpl <Base> MngCursor;

           ISortedBagOnKeySortedBagImpl
                            (Ops&, INumber);

           ISortedBagOnKeySortedBagImpl
                            (Ops&, ISortedBagOnKeySortedBagImpl
                              <Base> const&);

          ~ISortedBagOnKeySortedBagImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfDifferentElements
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextDifferentElement
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedBagOnKeySortedBagImpl
                              <Base> const&);

  IBoolean operator==       (IASortedBagImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedBagOnKeySortedBagImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedBagOnKeySortedBagImpl
                              <Base> const&);

  friend
  class    ISortedBagOnKeySortedBagMngCursorImpl <Base>;


};

template <class Base>
class IASortedBagOnKeySortedBagOps {
public:

  virtual ~IASortedBagOnKeySortedBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

  // for backward compatibility
           IASortedBagOnKeySortedBagOps
                            (IBoolean);

private:


};

#pragma SOMAsDefault (pop)

#include <iisbksb.inl>


#pragma info (restore)
#pragma pack ()

#endif
