/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISBTAB_H
#define _IISBTAB_H

#include <iisbksb.h>


#include <iiksbtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef ISortedBagOnKeySortedBagImpl
         <IKeySortedBagAsTableImpl> ISortedBagAsTableImpl;

typedef IASortedBagOnKeySortedBagOps
          <IKeySortedBagAsTableImpl> IASortedBagAsTableOps;

template <class Element, class ElementOps, class Implementation>
class ISortedBagAsTableOps :
  public IASortedBagAsTableOps {

  typedef  IASortedBagAsTableOps Inherited;

  typedef  ISortedBagAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedBagAsTableImpl > Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedBagAsTableOps
                           (INumber);

           ISortedBagAsTableOps
                           (INumber, void*);

           ISortedBagAsTableOps
                           (ISortedBagAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iisbtab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
