/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <new.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// -----------------------
// ISequenceAsDilTableImpl
// -----------------------

// public members

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ISequenceAsDilTableOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivElementOps (),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ISequenceAsDilTableOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivElementOps (opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ISequenceAsDilTableOps
  (ISequenceAsDilTableOps <Element, ElementOps,
                           Implementation> const& collection)
: Inherited (__isDTSClass (Element)),
  ivElementOps (collection.ivElementOps),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
~ISequenceAsDilTableOps ()
{
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
Assign (void* element1, void const* element2) const
{ ivElementOps.Assign (*(Element*)element1,
                       *(Element const*)element2);
}

template <class Element, class ElementOps, class Implementation>
IACollectionImpl*
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ConstructNode (void* node, void const* element) const
{ new (node) Node (*(Element const*)element);
}

template <class Element, class ElementOps, class Implementation>
void*
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
CreateNodes (INumber n, size_t& size) const
{ size = sizeof (Node) > 2 * sizeof (Node*) ?
         sizeof (Node) : 2 * sizeof (Node*);
  void* node = ivElementOps.Allocate ((size_t) (size * n)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
                                     );
  return ivImpl.CheckPointer (node);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
DeleteNodes (void* nodes) const
{ ivElementOps.Deallocate (nodes
#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif
                          );
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
DestroyNode (void* node) const
{ ((Node*)node)->~Node ();
}

template <class Element, class ElementOps, class Implementation>
void*
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
StreamIn (TStream& fromWhere) const
{ Element* element = ivElementOps.GetStreamable ();
  ivElementOps.StreamIn (*element, fromWhere);
  return (void*) element;
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
StreamOut (void const* element, TStream& toWhere) const
{ ivElementOps.StreamOut (*(Element const*)element, toWhere);
}

template <class Element, class ElementOps, class Implementation>
TStream&
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
operator<<= (TStream& fromWhere)
{ return (ivElementOps <<= fromWhere);
}

template <class Element, class ElementOps, class Implementation>
TStream&
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
operator>>= (TStream& toWhere) const
{ return (ivElementOps >>= toWhere);
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#pragma info (restore)
#pragma pack ()
