/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISEQLST_H
#define _IISEQLST_H

#include <iiaseq.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
struct ISequenceAsListNodeImpl;

template <class Element>
struct ISequenceAsListNodeImpl {

  ISequenceAsListNodeImpl <Element>
          *ivNext,
          *ivPrevious;

  Element  ivElement;

           ISequenceAsListNodeImpl
                            (Element const&);

          ~ISequenceAsListNodeImpl
                            ();


};

#pragma SOMAsDefault (pop)
#pragma SOMAsDefault (off)

class ISequenceAsListCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  ISequenceAsListCursorImpl Self;

public:

           ISequenceAsListCursorImpl
                            (IACollectionImpl const&);

           ISequenceAsListCursorImpl
                            (ISequenceAsListCursorImpl const&);

          ~ISequenceAsListCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  IBoolean IsInBetween      () const;

  IBoolean IsValid          () const;

  void     operator=        (ISequenceAsListCursorImpl const&);

  IBoolean operator==       (ICursorImpl const&) const;

protected:

private:

  ISequenceAsListNodeImpl <long>*
           ivNode;

  friend
  class    ISequenceAsListImpl;


};


class IASequenceAsListOps;

class ISequenceAsListImpl : public IASequenceImpl {

  typedef  IASequenceImpl Inherited;

  typedef  ISequenceAsListImpl Self;

  typedef  ISequenceAsListNodeImpl <long> Node;

public:

  typedef  IASequenceAsListOps Ops;

  typedef  ISequenceAsListCursorImpl Cursor;

  typedef  ISequenceAsListCursorImpl MngCursor;

           ISequenceAsListImpl
                            (Ops&, INumber);

           ISequenceAsListImpl
                            (Ops&,
                             ISequenceAsListImpl const&);

          ~ISequenceAsListImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  void     Reverse          ();

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (ISequenceAsListImpl const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  Node*    ivFirst;

  Node*    ivLast;

  INumber  ivNumberOfElements;

  void     AddAsNextNode    (Node*, Node*);

  void*    ElementOf        (Node const*) const;

  static
  IBoolean IsInBetween      (ICursorImpl const&);

  static
  Node*&   NextNodeOf       (ICursorImpl const&);

  static
  Node*&   NodeOf           (ICursorImpl const&);

  static
  Ops&     OpsOf            (ISequenceAsListImpl const&);

  static
  Node*&   PreviousNodeOf   (ICursorImpl const&);

  void     RemoveNode       (Node*);

  void     SetInBetween     (MngCursor&) const;

  void     SetNodeToPosition
                            (IPosition, Node*&) const;

  friend
  class    ISequenceAsListMngCursorImpl;


};

class IASequenceAsListOps {
public:

  virtual ~IASequenceAsListOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNode       (void const*) const = 0;

  virtual
  void     DeleteNode       (void*) const = 0;

  virtual
  void*    StreamIn         (TStream&) const = 0;

  virtual
  void     StreamOut        (void const*, TStream&) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

protected:

           IASequenceAsListOps
                            (IBoolean);

private:

  IBoolean ivContainsDTSObjects;

  friend
  class    ISequenceAsListImpl;


};

template <class Element, class ElementOps, class Implementation>
class ISequenceAsListOps : public IASequenceAsListOps {

  typedef  IASequenceAsListOps Inherited;

  typedef  ISequenceAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsListNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISequenceAsListOps
                            (INumber);

           ISequenceAsListOps
                            (INumber, void*);

           ISequenceAsListOps
                            (ISequenceAsListOps
                              <Element, ElementOps,
                               Implementation> const&);

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

           operator Implementation*
                            ();


protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#include <iiseqlst.inl>

#if ! defined (__TEMPINC__)
#include <iiseqlst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
