/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <new.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// -------------------
// ISequenceAsTableOps
// -------------------

// public members

template <class Element, class ElementOps, class Implementation>
ISequenceAsTableOps <Element, ElementOps, Implementation>::
ISequenceAsTableOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivElementOps (),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsTableOps <Element, ElementOps, Implementation>::
ISequenceAsTableOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivElementOps (opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsTableOps <Element, ElementOps, Implementation>::
ISequenceAsTableOps
  (ISequenceAsTableOps <Element, ElementOps,
                        Implementation> const& collection)
: Inherited (__isDTSClass (Element)),
  ivElementOps (collection.ivElementOps),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsTableOps <Element, ElementOps, Implementation>::
~ISequenceAsTableOps ()
{
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
Assign (void* element1, void const* element2) const
{ ivElementOps.Assign (*(Element*)element1,
                       *(Element const*)element2);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
BlockLeft (INumber target, INumber count)
{ INumber i = target;
  new (TableOf (ivImpl).NodeAtIndex (i))
    Node (((Node const*) TableOf (ivImpl).
                           NodeAtIndex (i + 1))->ivElement);
  for (i++, count--; count > 0; i++, count--) {
     ivElementOps.Assign
       (((Node*) TableOf (ivImpl).NodeAtIndex (i))->ivElement,
        ((Node const*) TableOf (ivImpl).
                         NodeAtIndex (i + 1))->ivElement);
  }
  ((Node*) TableOf (ivImpl).NodeAtIndex (i))->~Node ();
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
BlockRight (INumber target, INumber count)
{ INumber i = target + count - 1;
  new (TableOf (ivImpl).NodeAtIndex (i))
    Node (((Node const*) TableOf (ivImpl).
                           NodeAtIndex (i - 1))->ivElement);
  for (i--, count--; count > 0; i--, count--) {
     ivElementOps.Assign
       (((Node*) TableOf (ivImpl).NodeAtIndex (i))->ivElement,
        ((Node const*) TableOf (ivImpl).
                         NodeAtIndex (i - 1))->ivElement);
  }
  ((Node*) TableOf (ivImpl).NodeAtIndex (i))->~Node ();
}

template <class Element, class ElementOps, class Implementation>
IACollectionImpl*
ISequenceAsTableOps <Element, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
CopyFrom (ITableImpl const& from)
{ INumber toIndex = TableOf (ivImpl).ivLast;
  INumber fromIndex = from.ivFirst;
  for (INumber i = 0; i < from.ivNumberOfElements; i++) {
    TableOf (ivImpl).IncMod (toIndex);
    new (TableOf (ivImpl).NodeAtIndex (toIndex))
      Node (((Node const*) from.NodeAtIndex (fromIndex))->ivElement);
    from.IncMod (fromIndex);
  }
  TableOf (ivImpl).ivNumberOfElements += from.ivNumberOfElements;
  TableOf (ivImpl).ivLast = toIndex;

}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
ConstructNode (void* node, void const* element) const
{ new (node) Node (*(Element const*)element);
}

template <class Element, class ElementOps, class Implementation>
void*
ISequenceAsTableOps <Element, ElementOps, Implementation>::
CreateNodes (INumber n, size_t& size)
{ size = sizeof (Node);
  void* node = ivElementOps.Allocate ((size_t) (size * n)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
                                     );
  return IACollectionImpl::CheckPointer (node);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
DeleteNodes (void* nodes)
{ ivElementOps.Deallocate (nodes
#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif
                          );
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
DestroyNodes (void* node, INumber count) const
{ while (count--)
    ((Node*)node) [count].~Node ();
}

template <class Element, class ElementOps, class Implementation>
void*
ISequenceAsTableOps <Element, ElementOps, Implementation>::
StreamIn (TStream& fromWhere) const
{ Element* element = ivElementOps.GetStreamable ();
  ivElementOps.StreamIn (*element, fromWhere);
  return (void*) element;
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
StreamOut (void const* element, TStream& toWhere) const
{ ivElementOps.StreamOut (*(Element const*)element, toWhere);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsTableOps <Element, ElementOps, Implementation>::
Swap (INumber index1, INumber index2) const
{ Element e =
    ((Node*) TableOf (ivImpl).NodeAtIndex (index1))->ivElement;
  ivElementOps.Assign
    (((Node*) TableOf (ivImpl).NodeAtIndex (index1))->ivElement,
     ((Node const*) TableOf (ivImpl).NodeAtIndex (index2))->ivElement);
  ivElementOps.Assign
    (((Node*) TableOf (ivImpl).NodeAtIndex (index2))->ivElement, e);
}

template <class Element, class ElementOps, class Implementation>
TStream&
ISequenceAsTableOps <Element, ElementOps, Implementation>::
operator<<= (TStream& fromWhere)
{ return (ivElementOps <<= fromWhere);
}

template <class Element, class ElementOps, class Implementation>
TStream&
ISequenceAsTableOps <Element, ElementOps, Implementation>::
operator>>= (TStream& toWhere) const
{ return (ivElementOps >>= toWhere);
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsTableOps <Element, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#pragma info (restore)
#pragma pack ()
