/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISETKS_H
#define _IISETKS_H

#include <iiaset.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class ISetOnKeySetMngCursorImpl;

template <class Base>
class ISetOnKeySetImpl;

template <class Base>
class ISetOnKeySetMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           ISetOnKeySetMngCursorImpl
                            (ISetOnKeySetImpl <Base> const&);

          ~ISetOnKeySetMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IASetOnKeySetOps;

template <class Base>
class ISetOnKeySetImpl : public IASetImpl {

  typedef  IASetImpl Inherited;

  typedef  ISetOnKeySetImpl <Base> Self;

public:

  typedef  IASetOnKeySetOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  ISetOnKeySetMngCursorImpl <Base> MngCursor;

           ISetOnKeySetImpl (Ops&, INumber);

           ISetOnKeySetImpl (Ops&, ISetOnKeySetImpl <Base> const&);

          ~ISetOnKeySetImpl ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     operator=        (ISetOnKeySetImpl <Base> const&);

  IBoolean operator==       (IASetImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISetOnKeySetImpl <Base> const&);

  static
  Ops&     OpsOf            (ISetOnKeySetImpl <Base> const&);

  friend
  class    ISetOnKeySetMngCursorImpl <Base>;


};

template <class Base>
class IASetOnKeySetOps {
public:

  virtual ~IASetOnKeySetOps ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iisetks.inl>


#pragma info (restore)
#pragma pack ()

#endif
