/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISMKSS_H
#define _IISMKSS_H

#include <iiasm.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class ISortedMapOnKeySortedSetMngCursorImpl;

template <class Base>
class ISortedMapOnKeySortedSetImpl;

template <class Base>
class ISortedMapOnKeySortedSetMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           ISortedMapOnKeySortedSetMngCursorImpl
                            (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

          ~ISortedMapOnKeySortedSetMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IASortedMapOnKeySortedSetOps;

template <class Base>
class ISortedMapOnKeySortedSetImpl : public IASortedMapImpl {

  typedef  IASortedMapImpl Inherited;

  typedef  ISortedMapOnKeySortedSetImpl <Base> Self;

public:

  typedef  IASortedMapOnKeySortedSetOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  ISortedMapOnKeySortedSetMngCursorImpl <Base> MngCursor;

           ISortedMapOnKeySortedSetImpl
                            (Ops&, INumber);

           ISortedMapOnKeySortedSetImpl
                            (Ops&,
                             ISortedMapOnKeySortedSetImpl
                              <Base> const&);

          ~ISortedMapOnKeySortedSetImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

  IBoolean operator==       (IASortedMapImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

  friend
  class    ISortedMapOnKeySortedSetMngCursorImpl <Base>;


};

template <class Base>
class IASortedMapOnKeySortedSetOps {
public:

  virtual ~IASortedMapOnKeySortedSetOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  IBoolean EqualElements    (void const*, void const*) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iismkss.inl>


#pragma info (restore)
#pragma pack ()

#endif
