/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISRKSB_H
#define _IISRKSB_H

#include <iiasr.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class ISortedRelationOnKeySortedBagMngCursorImpl;

template <class Base>
class ISortedRelationOnKeySortedBagImpl;

template <class Base>
class ISortedRelationOnKeySortedBagMngCursorImpl :
  public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           ISortedRelationOnKeySortedBagMngCursorImpl
                            (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

          ~ISortedRelationOnKeySortedBagMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IASortedRelationOnKeySortedBagOps;

template <class Base>
class ISortedRelationOnKeySortedBagImpl : public IASortedRelationImpl {

  typedef  IASortedRelationImpl Inherited;

  typedef  ISortedRelationOnKeySortedBagImpl <Base> Self;

public:

  typedef  IASortedRelationOnKeySortedBagOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  ISortedRelationOnKeySortedBagMngCursorImpl <Base> MngCursor;

           ISortedRelationOnKeySortedBagImpl
                            (Ops&, INumber);

           ISortedRelationOnKeySortedBagImpl
                            (Ops&,
                             ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

          ~ISortedRelationOnKeySortedBagImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

  IBoolean operator==       (IASortedRelationImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

  friend
  class    ISortedRelationOnKeySortedBagMngCursorImpl <Base>;


};

template <class Base>
class IASortedRelationOnKeySortedBagOps {
public:

  virtual ~IASortedRelationOnKeySortedBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  IBoolean EqualElements    (void const*, void const*) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iisrksb.inl>


#pragma info (restore)
#pragma pack ()

#endif
