/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISSAVL_H
#define _IISSAVL_H

#include <iisskss.h>


#include <iikssavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef ISortedSetOnKeySortedSetImpl
         <IKeySortedSetAsAvlTreeImpl> ISortedSetAsAvlTreeImpl;

typedef IASortedSetOnKeySortedSetOps
         <IKeySortedSetAsAvlTreeImpl> IASortedSetAsAvlTreeOps;

template <class Element, class ElementOps, class Implementation>
class ISortedSetAsAvlTreeOps :
  public IASortedSetAsAvlTreeOps {

  typedef  ISortedSetAsAvlTreeOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsAvlTreeOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedSetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedSetAsAvlTreeOps
                           (INumber);

           ISortedSetAsAvlTreeOps
                           (INumber, void*);

           ISortedSetAsAvlTreeOps
                           (ISortedSetAsAvlTreeOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedSetAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iissavl.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
