/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IITABLE_H
#define _IITABLE_H

#include <iiglobal.h>
#include <stddef.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

struct ITableImpl {

  INumber  ivFirst,
           ivLast;

  INumber  ivAllocatedElements,
           ivNumberOfElements;

  void*    ivNodes;

  size_t   ivNodeSize;

  INumber& AddMod           (INumber&, INumber) const;

  IBoolean CanAdd           (INumber) const;

  INumber& DecMod           (INumber&) const;

  INumber& IncMod           (INumber&) const;

  void*    NodeAtIndex      (INumber) const;

  INumber  Pos              (INumber) const;

};

#pragma SOMAsDefault (pop)

#include <iitable.inl>

#pragma info (restore)
#pragma pack ()

#endif
